/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.javaflow.providers.asm5;

import org.apache.commons.javaflow.providers.asm5.ContinuableClassInfoResolver;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;

class MaybeContinuableAnnotationVisitor
extends ClassVisitor {
    private final ContinuableClassInfoResolver cciResolver;
    private boolean classContinuableAnnotationFound = false;
    private boolean isAnnotation = false;

    MaybeContinuableAnnotationVisitor(ContinuableClassInfoResolver cciResolver) {
        super(327680);
        this.cciResolver = cciResolver;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.isAnnotation = (access & 0x2000) > 0;
    }

    public AnnotationVisitor visitAnnotation(String description, boolean visible) {
        if (this.isAnnotation && !this.classContinuableAnnotationFound) {
            this.classContinuableAnnotationFound = this.cciResolver.isContinuableAnnotation(description);
        }
        return null;
    }

    boolean isContinuable() {
        return this.classContinuableAnnotationFound && this.isAnnotation;
    }
}

