/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.javaflow.providers.asm5;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LocalVariableAnnotationNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MultiANewArrayInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

class CallSiteFinder {
    CallSiteFinder() {
    }

    List<Result> findMatchingCallSites(InsnList instructions, List<LocalVariableAnnotationNode> varAnnotations, Map<Integer, List<AnnotationNode>> paramAnnotations) {
        ArrayList<Result> result = new ArrayList<Result>();
        for (AbstractInsnNode ins : instructions) {
            MethodInsnNode mins;
            Result entry;
            if (!(ins instanceof MethodInsnNode) || (entry = this.findMatchingCallSite(mins = (MethodInsnNode)ins, varAnnotations, paramAnnotations)) == null) continue;
            result.add(entry);
        }
        return result;
    }

    static List<LocalVariableAnnotationNode> annotationsList(List<?> v) {
        return null == v ? Collections.emptyList() : v;
    }

    static Map<Integer, List<AnnotationNode>> annotationsList(List<?>[] v) {
        if (v == null) {
            return Collections.emptyMap();
        }
        HashMap<Integer, List<AnnotationNode>> result = new HashMap<Integer, List<AnnotationNode>>();
        int i = 0;
        for (List<?> list : v) {
            List<?> typedList = list;
            if (null == typedList) continue;
            result.put(i++, typedList);
        }
        return result;
    }

    private Result findMatchingCallSite(MethodInsnNode m, List<LocalVariableAnnotationNode> varAnnotations, Map<Integer, List<AnnotationNode>> paramAnnotations) {
        int opcode = m.getOpcode();
        if (182 != opcode && 185 != opcode) {
            return null;
        }
        int size = Type.getArgumentsAndReturnSizes((String)m.desc) >> 2;
        int argCount = Type.getArgumentTypes((String)m.desc).length;
        assert (size >= 1);
        for (AbstractInsnNode n = m.getPrevious(); n != null; n = n.getPrevious()) {
            if ((size -= CallSiteFinder.getStackSizeChange(n)) == 0) {
                if (n instanceof VarInsnNode) {
                    VarInsnNode v = (VarInsnNode)n;
                    Set<String> annotations = v.var > argCount ? this.getVarAnnotations(varAnnotations, v) : this.getParamAnnotations(paramAnnotations, v.var - 1);
                    return new Result((AbstractInsnNode)v, m, annotations);
                }
                if (!(n instanceof FieldInsnNode)) break;
                return new Result(n, m, Collections.<String>emptySet());
            }
            if (size > 0) continue;
            throw new RuntimeException();
        }
        return null;
    }

    private Set<String> getVarAnnotations(List<LocalVariableAnnotationNode> varAnnotations, VarInsnNode v) {
        TreeSet<String> result = new TreeSet<String>();
        for (LocalVariableAnnotationNode n : varAnnotations) {
            LabelNode end;
            LabelNode start;
            int idx = n.index.indexOf(v.var);
            if (idx < 0 || !this.isVarBetweenBounds((AbstractInsnNode)v, start = (LabelNode)n.start.get(idx), end = (LabelNode)n.end.get(idx))) continue;
            result.add(n.desc);
        }
        return result;
    }

    private boolean isVarBetweenBounds(AbstractInsnNode var, LabelNode lo, LabelNode hi) {
        AbstractInsnNode x;
        boolean loFound = false;
        for (x = var; x != null && !loFound; x = x.getPrevious()) {
            loFound = x == lo;
        }
        if (!loFound) {
            return false;
        }
        boolean hiFound = false;
        for (x = var; x != null && !hiFound; x = x.getNext()) {
            hiFound = x == hi;
        }
        return hiFound;
    }

    private Set<String> getParamAnnotations(Map<Integer, List<AnnotationNode>> paramAnnotations, int varIdx) {
        TreeSet<String> result = new TreeSet<String>();
        List<AnnotationNode> annos = paramAnnotations.get(varIdx);
        if (null != annos) {
            for (AnnotationNode n : annos) {
                result.add(n.desc);
            }
        }
        return result;
    }

    private static int getStackSizeChange(AbstractInsnNode ins) {
        int o = ins.getOpcode();
        if (o < 0) {
            return 0;
        }
        switch (o) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return 1;
            }
            case 9: 
            case 10: {
                return 2;
            }
            case 11: 
            case 12: 
            case 13: {
                return 1;
            }
            case 14: 
            case 15: {
                return 2;
            }
            case 16: 
            case 17: {
                return 1;
            }
            case 18: {
                LdcInsnNode l = (LdcInsnNode)ins;
                if (l.cst instanceof Long || l.cst instanceof Double) {
                    return 2;
                }
                return 1;
            }
            case 21: {
                return 1;
            }
            case 22: {
                return 2;
            }
            case 23: {
                return 1;
            }
            case 24: {
                return 2;
            }
            case 25: {
                return 1;
            }
            case 46: {
                return -1;
            }
            case 47: {
                return 0;
            }
            case 48: {
                return -1;
            }
            case 49: {
                return 0;
            }
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                return -1;
            }
            case 54: {
                return -1;
            }
            case 55: {
                return -2;
            }
            case 56: {
                return -1;
            }
            case 57: {
                return -2;
            }
            case 58: {
                return -1;
            }
            case 79: {
                return -3;
            }
            case 80: {
                return -4;
            }
            case 81: {
                return -3;
            }
            case 82: {
                return -4;
            }
            case 83: 
            case 84: 
            case 85: 
            case 86: {
                return -3;
            }
            case 87: {
                return -1;
            }
            case 88: {
                return -2;
            }
            case 89: 
            case 90: 
            case 91: {
                return 1;
            }
            case 92: 
            case 93: {
                return 2;
            }
            case 94: {
                return 2;
            }
            case 95: {
                return 0;
            }
            case 96: {
                return -1;
            }
            case 97: {
                return -2;
            }
            case 98: {
                return -1;
            }
            case 99: {
                return -2;
            }
            case 100: {
                return -1;
            }
            case 101: {
                return -2;
            }
            case 102: {
                return -1;
            }
            case 103: {
                return -2;
            }
            case 104: {
                return -1;
            }
            case 105: {
                return -2;
            }
            case 106: {
                return -1;
            }
            case 107: {
                return -2;
            }
            case 108: {
                return -1;
            }
            case 109: {
                return -2;
            }
            case 110: {
                return -1;
            }
            case 111: {
                return -2;
            }
            case 112: {
                return -1;
            }
            case 113: {
                return -2;
            }
            case 114: {
                return -1;
            }
            case 115: {
                return -2;
            }
            case 116: 
            case 117: 
            case 118: 
            case 119: {
                return 0;
            }
            case 120: {
                return -1;
            }
            case 121: {
                return -2;
            }
            case 122: {
                return -1;
            }
            case 123: {
                return -2;
            }
            case 124: {
                return -1;
            }
            case 125: {
                return -2;
            }
            case 126: {
                return -1;
            }
            case 127: {
                return -2;
            }
            case 128: {
                return -1;
            }
            case 129: {
                return -2;
            }
            case 130: {
                return -1;
            }
            case 131: {
                return -2;
            }
            case 132: {
                return 0;
            }
            case 133: {
                return 1;
            }
            case 134: {
                return 0;
            }
            case 135: {
                return 1;
            }
            case 136: {
                return -1;
            }
            case 137: {
                return -1;
            }
            case 138: {
                return 0;
            }
            case 139: {
                return 0;
            }
            case 140: {
                return 1;
            }
            case 141: {
                return 1;
            }
            case 142: {
                return -1;
            }
            case 143: {
                return 0;
            }
            case 144: {
                return -1;
            }
            case 145: {
                return 0;
            }
            case 146: {
                return 0;
            }
            case 147: {
                return 0;
            }
            case 148: {
                return -3;
            }
            case 149: 
            case 150: {
                return -1;
            }
            case 151: 
            case 152: {
                return -3;
            }
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: {
                return -1;
            }
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: {
                return -2;
            }
            case 167: {
                return 0;
            }
            case 168: {
                return 1;
            }
            case 169: {
                return 0;
            }
            case 170: 
            case 171: {
                return -1;
            }
            case 172: {
                return -1;
            }
            case 173: {
                return -2;
            }
            case 174: {
                return -1;
            }
            case 175: {
                return -2;
            }
            case 176: {
                return -1;
            }
            case 177: {
                return 0;
            }
            case 178: 
            case 179: {
                FieldInsnNode fs = (FieldInsnNode)ins;
                return Type.getType((String)fs.desc).getSize() * (o == 179 ? -1 : 1);
            }
            case 180: {
                FieldInsnNode fg = (FieldInsnNode)ins;
                return -1 + Type.getType((String)fg.desc).getSize();
            }
            case 181: {
                FieldInsnNode fp = (FieldInsnNode)ins;
                return -1 - Type.getType((String)fp.desc).getSize();
            }
            case 182: 
            case 183: 
            case 184: 
            case 185: {
                MethodInsnNode m = (MethodInsnNode)ins;
                int s = Type.getArgumentsAndReturnSizes((String)m.desc);
                return -(s / 2) + s % 2;
            }
            case 186: {
                InvokeDynamicInsnNode d = (InvokeDynamicInsnNode)ins;
                int s = Type.getArgumentsAndReturnSizes((String)d.desc);
                return -(s / 2) + s % 2;
            }
            case 187: {
                return 1;
            }
            case 188: 
            case 189: {
                return 0;
            }
            case 190: {
                return 0;
            }
            case 191: {
                return -1;
            }
            case 192: {
                return 0;
            }
            case 193: {
                return 0;
            }
            case 194: 
            case 195: {
                return -1;
            }
            case 197: {
                MultiANewArrayInsnNode ma = (MultiANewArrayInsnNode)ins;
                return -ma.dims + 1;
            }
            case 198: 
            case 199: {
                return -1;
            }
        }
        throw new RuntimeException(ins.toString() + " = " + ins.getOpcode());
    }

    static class Result {
        final AbstractInsnNode callSite;
        final MethodInsnNode methodCall;
        final Set<String> annotations;

        Result(AbstractInsnNode callSite, MethodInsnNode methodCall, Set<String> annotations) {
            this.callSite = callSite;
            this.methodCall = methodCall;
            this.annotations = annotations;
        }

        public String toString() {
            String caller = this.callSite instanceof VarInsnNode ? "Var #" + ((VarInsnNode)VarInsnNode.class.cast((Object)this.callSite)).var : "Field";
            return '{' + caller + '.' + this.methodCall.name + this.methodCall.desc + this.annotations + '}';
        }
    }
}

