/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.javaflow.providers.asm5;

import java.util.Map;
import java.util.WeakHashMap;
import org.apache.commons.javaflow.providers.asm5.Asm5ClassTransformer;
import org.apache.commons.javaflow.providers.asm5.Asm5ContinuableClassInfoResolver;
import org.apache.commons.javaflow.providers.asm5.InheritanceLookup;
import org.apache.commons.javaflow.spi.ContinuableClassInfoResolver;
import org.apache.commons.javaflow.spi.ResourceLoader;
import org.apache.commons.javaflow.spi.ResourceTransformationFactory;
import org.apache.commons.javaflow.spi.ResourceTransformer;

public class Asm5ResourceTransformationFactory
implements ResourceTransformationFactory {
    private static final Map<ContinuableClassInfoResolver, InheritanceLookup> CACHED_INHERITANCE_LOOKUP = new WeakHashMap<ContinuableClassInfoResolver, InheritanceLookup>();

    public ResourceTransformer createTransformer(ContinuableClassInfoResolver cciResolver) {
        return new Asm5ClassTransformer(Asm5ResourceTransformationFactory.getOrCreateInheritanceLookup(cciResolver), cciResolver);
    }

    public ContinuableClassInfoResolver createResolver(ResourceLoader resourceLoader) {
        return new Asm5ContinuableClassInfoResolver(resourceLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static InheritanceLookup getOrCreateInheritanceLookup(ContinuableClassInfoResolver cciResolver) {
        InheritanceLookup result;
        Map<ContinuableClassInfoResolver, InheritanceLookup> map = CACHED_INHERITANCE_LOOKUP;
        synchronized (map) {
            result = CACHED_INHERITANCE_LOOKUP.get(cciResolver);
            if (null == result) {
                result = new InheritanceLookup(cciResolver.resourceLoader());
                CACHED_INHERITANCE_LOOKUP.put(cciResolver, result);
            }
        }
        return result;
    }
}

