/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.javaflow.providers.asm5;

import org.apache.commons.javaflow.providers.asm5.ContinuableClassVisitor;
import org.apache.commons.javaflow.providers.asm5.InheritanceLookup;
import org.apache.commons.javaflow.spi.ContinuableClassInfoResolver;
import org.apache.commons.javaflow.spi.ResourceTransformer;
import org.apache.commons.javaflow.spi.StopException;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

final class Asm5ClassTransformer
implements ResourceTransformer {
    private final InheritanceLookup inheritanceLookup;
    private final ContinuableClassInfoResolver cciResolver;

    Asm5ClassTransformer(InheritanceLookup inheritanceLookup, ContinuableClassInfoResolver cciResolver) {
        this.inheritanceLookup = inheritanceLookup;
        this.cciResolver = cciResolver;
    }

    public byte[] transform(byte[] original) {
        ClassWriter cw = new ClassWriter(2){

            protected String getCommonSuperClass(String type1, String type2) {
                return Asm5ClassTransformer.this.inheritanceLookup.getCommonSuperClass(type1, type2);
            }
        };
        ContinuableClassVisitor visitor = new ContinuableClassVisitor((ClassVisitor)cw, this.inheritanceLookup, this.cciResolver, original);
        try {
            new ClassReader(original).accept((ClassVisitor)visitor, 4);
        }
        catch (StopException ex) {
            return null;
        }
        if (visitor.skipEnchancing()) {
            return null;
        }
        byte[] bytecode = cw.toByteArray();
        return bytecode;
    }
}

