/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.javaflow.providers.asm5;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.javaflow.providers.asm5.Asm5ContinuableClassInfoResolver;
import org.apache.commons.javaflow.providers.asm5.ContinuableClassInfoInternal;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

class MaybeContinuableClassVisitor
extends ClassVisitor {
    private final Asm5ContinuableClassInfoResolver environment;
    private boolean classContinuatedMarkerFound = false;
    private String selfclass;
    private String superclass;
    private String[] superinterfaces;
    private String outerClassName;
    private String outerClassMethodName;
    private String outerClassMethodDesc;
    private final Map<String, String> actual2accessor = new HashMap<String, String>();
    private final Map<String, String> bridge2specialization = new HashMap<String, String>();
    private final Set<String> desugaredLambdaBodies = new HashSet<String>();
    final Set<String> continuableMethods = new HashSet<String>();
    private boolean isAnnotation = false;
    private boolean inheritanceChainVisited = false;
    static final String MARKER_FIELD_NAME = "___$$$CONT$$$___";
    private static final String OBJECT_CLASS_INTERNAL_NAME = Type.getInternalName(Object.class);

    public MaybeContinuableClassVisitor(Asm5ContinuableClassInfoResolver environment) {
        super(327680);
        this.environment = environment;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.isAnnotation = (access & 0x2000) > 0;
        this.selfclass = name;
        this.superclass = superName;
        this.superinterfaces = interfaces;
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        if (!this.isAnnotation && MARKER_FIELD_NAME.equals(name) && (access & 8) != 0) {
            this.classContinuatedMarkerFound = true;
        }
        return null;
    }

    public void visitOuterClass(String owner, String name, String desc) {
        this.outerClassName = owner;
        this.outerClassMethodName = name;
        this.outerClassMethodDesc = desc;
    }

    public MethodVisitor visitMethod(int access, final String name, final String desc, String signature, String[] exceptions) {
        boolean isSynthetic;
        if (this.isAnnotation) {
            return null;
        }
        boolean bl = isSynthetic = (access & 0x1000) != 0;
        if (isSynthetic) {
            boolean isBridge;
            boolean isPackagePrivate = (access & 7) == 0;
            final boolean isAccessor = isPackagePrivate && name.startsWith("access$") && (access & 8) != 0;
            boolean bl2 = isBridge = (access & 0x40) != 0;
            if (isAccessor || isBridge) {
                return new MethodVisitor(327680){

                    public void visitMethodInsn(int opcode, String owner, String targetName, String targetDesc, boolean intf) {
                        if (MaybeContinuableClassVisitor.this.selfclass.equals(owner)) {
                            if (isAccessor) {
                                MaybeContinuableClassVisitor.this.actual2accessor.put(targetName + targetDesc, name + desc);
                            }
                            if (isBridge) {
                                MaybeContinuableClassVisitor.this.bridge2specialization.put(name + desc, targetName + targetDesc);
                            }
                        }
                    }

                    public void visitMethodInsn(int opcode, String owner, String name2, String desc2) {
                        this.visitMethodInsn(opcode, owner, name2, desc2, false);
                    }
                };
            }
        }
        if (isSynthetic && (access & 2) != 0 && name.startsWith("lambda$")) {
            this.desugaredLambdaBodies.add(name + desc);
            return null;
        }
        return new MethodVisitor(327680){
            private boolean methodContinuableAnnotationFound;
            {
                super(x0);
                this.methodContinuableAnnotationFound = false;
            }

            public AnnotationVisitor visitAnnotation(String description, boolean visible) {
                if (!this.methodContinuableAnnotationFound) {
                    this.methodContinuableAnnotationFound = MaybeContinuableClassVisitor.this.environment.isContinuableAnnotation(description);
                }
                return null;
            }

            public void visitEnd() {
                if (this.methodContinuableAnnotationFound) {
                    MaybeContinuableClassVisitor.this.continuableMethods.add(name + desc);
                }
            }
        };
    }

    public void visitEnd() {
        for (Map.Entry<String, String> n2s : this.actual2accessor.entrySet()) {
            if (!this.continuableMethods.contains(n2s.getKey())) continue;
            this.continuableMethods.add(n2s.getValue());
        }
        this.visitInheritanceChain();
        this.checkOuterClass();
        for (Map.Entry<String, String> n2s : this.bridge2specialization.entrySet()) {
            if (!this.continuableMethods.contains(n2s.getKey())) continue;
            this.continuableMethods.add(n2s.getValue());
        }
        this.continuableMethods.addAll(this.desugaredLambdaBodies);
    }

    private void visitInheritanceChain() {
        if (!this.inheritanceChainVisited) {
            this.inheritanceChainVisited = true;
            if (!this.isAnnotation) {
                if (null != this.superclass && !OBJECT_CLASS_INTERNAL_NAME.equals(this.superclass)) {
                    this.visitParentClass(this.superclass);
                }
                if (null != this.superinterfaces) {
                    for (String superinterface : this.superinterfaces) {
                        this.visitParentClass(superinterface);
                    }
                }
            }
        }
    }

    private void visitParentClass(String classInternalName) {
        ContinuableClassInfoInternal parent = this.resolve(classInternalName);
        if (null != parent) {
            this.continuableMethods.addAll(parent.continuableMethods());
        }
    }

    private void checkOuterClass() {
        ContinuableClassInfoInternal outer;
        if (this.isAnnotation || this.outerClassName == null || this.outerClassMethodName == null || this.continuableMethods.isEmpty() || null == (outer = this.resolve(this.outerClassName)) || outer.isContinuableMethod(0, this.outerClassMethodName, this.outerClassMethodDesc, null)) {
            // empty if block
        }
    }

    private ContinuableClassInfoInternal resolve(String classInternalName) {
        try {
            return (ContinuableClassInfoInternal)this.environment.resolve(classInternalName);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    boolean isContinuable() {
        return !this.isAnnotation && !this.continuableMethods.isEmpty();
    }

    boolean isProcessed() {
        return this.classContinuatedMarkerFound;
    }
}

