/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.javaflow.providers.asm5;

import java.util.Collections;
import java.util.Map;
import org.apache.commons.javaflow.spi.StopException;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;

public class ClassNameResolver {
    public static Result resolveClassName(String className, Class<?> classBeingRedefined, byte[] classfileBuffer) {
        String resolvedClassName = className != null ? className : (classBeingRedefined != null ? classBeingRedefined.getName().replace('.', '/') : null);
        final String[] classNameFromBytes = new String[]{null};
        if (null == resolvedClassName) {
            try {
                ClassReader cv = new ClassReader(classfileBuffer);
                cv.accept(new ClassVisitor(327680){

                    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                        classNameFromBytes[0] = name;
                        throw StopException.INSTANCE;
                    }
                }, 7);
            }
            catch (StopException stopException) {
                // empty catch block
            }
            resolvedClassName = classNameFromBytes[0];
        }
        return new Result(resolvedClassName, classfileBuffer);
    }

    public static class Result {
        public final String className;
        public final byte[] classfileBuffer;

        Result(String className, byte[] classfileBuffer) {
            this.className = className;
            this.classfileBuffer = classfileBuffer;
        }

        public Map<String, byte[]> asResource() {
            return Collections.singletonMap(this.className + ".class", this.classfileBuffer);
        }
    }
}

