/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.javaflow.providers.asm5;

import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.analysis.AnalyzerException;
import org.objectweb.asm.tree.analysis.BasicValue;
import org.objectweb.asm.tree.analysis.BasicVerifier;

public class FastClassVerifier
extends BasicVerifier {
    public FastClassVerifier() {
        super(327680);
    }

    public BasicValue copyOperation(AbstractInsnNode insn, BasicValue value) throws AnalyzerException {
        if (!(insn.getOpcode() != 25 && insn.getOpcode() != 58 || value.isReference())) {
            value = this.newValue(Type.getType((String)"Lnull;"));
        }
        return super.copyOperation(insn, value);
    }

    public BasicValue unaryOperation(AbstractInsnNode insn, BasicValue value) throws AnalyzerException {
        if (insn.getOpcode() == 176 && !value.isReference()) {
            value = this.newValue(Type.getType((String)"Lnull;"));
        }
        return super.unaryOperation(insn, value);
    }

    public BasicValue newValue(Type type) {
        if (type == null) {
            return BasicValue.UNINITIALIZED_VALUE;
        }
        boolean isArray = type.getSort() == 9;
        BasicValue v = super.newValue(type);
        if (BasicValue.REFERENCE_VALUE.equals((Object)v)) {
            if (isArray) {
                v = this.newValue(type.getElementType());
                String desc = v.getType().getDescriptor();
                for (int i = 0; i < type.getDimensions(); ++i) {
                    desc = '[' + desc;
                }
                v = new BasicValue(Type.getType((String)desc));
            } else {
                v = new BasicValue(type);
            }
        }
        return v;
    }

    protected boolean isSubTypeOf(BasicValue value, BasicValue expected) {
        Type expectedType = expected.getType();
        Type type = value.getType();
        switch (expectedType.getSort()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return type.equals((Object)expectedType);
            }
            case 9: 
            case 10: {
                return true;
            }
        }
        throw new Error("Internal error");
    }
}

