/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.javaflow.providers.asm5;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.javaflow.api.Continuation;
import org.apache.commons.javaflow.providers.asm5.CallSiteFinder;
import org.apache.commons.javaflow.providers.asm5.ContinuableMethodVisitor;
import org.apache.commons.javaflow.providers.asm5.FastClassVerifier;
import org.apache.commons.javaflow.providers.asm5.MonitoringFrame;
import org.apache.commons.javaflow.spi.ContinuableClassInfo;
import org.apache.commons.javaflow.spi.ContinuableClassInfoResolver;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LocalVariableAnnotationNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.objectweb.asm.tree.analysis.Analyzer;
import org.objectweb.asm.tree.analysis.AnalyzerException;
import org.objectweb.asm.tree.analysis.Frame;
import org.objectweb.asm.tree.analysis.Interpreter;
import org.objectweb.asm.tree.analysis.SourceInterpreter;
import org.objectweb.asm.tree.analysis.SourceValue;

public class ContinuableMethodNode
extends MethodNode
implements Opcodes {
    private final ContinuableClassInfoResolver cciResolver;
    private final String className;
    protected final MethodVisitor mv;
    protected final List<Label> labels = new ArrayList<Label>();
    protected final List<AbstractInsnNode> nodes = new ArrayList<AbstractInsnNode>();
    protected final List<MethodInsnNode> methods = new ArrayList<MethodInsnNode>();
    protected Analyzer analyzer;
    public int stackRecorderVar;
    private static final String CONTINUATION_CLASS_INTERNAL_NAME = Type.getInternalName(Continuation.class);
    private static final Set<String> CONTINUATION_CLASS_CONTINUABLE_METHODS = new HashSet<String>(Arrays.asList("suspend", "again", "cancel"));

    public ContinuableMethodNode(int access, String name, String desc, String signature, String[] exceptions, String className, ContinuableClassInfoResolver cciResolver, MethodVisitor mv) {
        super(327680, access, name, desc, signature, exceptions);
        this.className = className;
        this.cciResolver = cciResolver;
        this.mv = mv;
    }

    protected LabelNode getLabelNode(Label l) {
        if (!(l.info instanceof LabelNode)) {
            l.info = new LabelNode(l);
        }
        return (LabelNode)l.info;
    }

    Frame getFrameByNode(AbstractInsnNode node) {
        int insIndex = this.instructions.indexOf(node);
        Frame[] frames = this.analyzer.getFrames();
        return null == frames || insIndex >= frames.length ? null : frames[insIndex];
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean intf) {
        MethodInsnNode mnode = new MethodInsnNode(opcode, owner, name, desc, intf);
        if (opcode == 183 || "<init>".equals(name)) {
            this.methods.add(mnode);
        }
        if (this.needsFrameGuard(opcode, owner, name, desc)) {
            Label label = new Label();
            super.visitLabel(label);
            this.labels.add(label);
            this.nodes.add((AbstractInsnNode)mnode);
        }
        this.instructions.add((AbstractInsnNode)mnode);
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc) {
        this.visitMethodInsn(opcode, owner, name, desc, opcode == 185);
    }

    public void visitInvokeDynamicInsn(String name, String desc, Handle bsm, Object ... bsmArgs) {
        InvokeDynamicInsnNode mnode = new InvokeDynamicInsnNode(name, desc, bsm, bsmArgs);
        if (this.needsFrameGuard(186, bsm.getOwner(), name, desc)) {
            Label label = new Label();
            super.visitLabel(label);
            this.labels.add(label);
            this.nodes.add((AbstractInsnNode)mnode);
        }
        this.instructions.add((AbstractInsnNode)mnode);
    }

    public void visitEnd() {
        this.checkCallSites();
        if (this.instructions.size() == 0 || this.labels.size() == 0) {
            this.accept(this.mv);
            return;
        }
        this.stackRecorderVar = this.maxLocals;
        try {
            this.moveNew();
            this.analyzer = new Analyzer((Interpreter)new FastClassVerifier()){

                protected Frame newFrame(int nLocals, int nStack) {
                    return new MonitoringFrame(nLocals, nStack);
                }

                protected Frame newFrame(Frame src) {
                    return new MonitoringFrame(src);
                }
            };
            this.analyzer.analyze(this.className, (MethodNode)this);
            this.accept(new ContinuableMethodVisitor(this));
        }
        catch (AnalyzerException ex) {
            throw new RuntimeException(ex);
        }
    }

    void checkCallSites() {
        ArrayList<LocalVariableAnnotationNode> varAnnotations = new ArrayList<LocalVariableAnnotationNode>();
        HashMap<Integer, List<AnnotationNode>> paramAnnotations = new HashMap<Integer, List<AnnotationNode>>();
        varAnnotations.addAll(CallSiteFinder.annotationsList(this.visibleLocalVariableAnnotations));
        varAnnotations.addAll(CallSiteFinder.annotationsList(this.invisibleLocalVariableAnnotations));
        paramAnnotations.putAll(CallSiteFinder.annotationsList(this.visibleParameterAnnotations));
        paramAnnotations.putAll(CallSiteFinder.annotationsList(this.invisibleParameterAnnotations));
        List<CallSiteFinder.Result> results = new CallSiteFinder().findMatchingCallSites(this.instructions, varAnnotations, paramAnnotations);
        for (CallSiteFinder.Result result : results) {
            if (this.nodes.contains(result.methodCall) || !this.checkContinuableAnnotation(result.annotations)) continue;
            Label label = new Label();
            this.instructions.insertBefore((AbstractInsnNode)result.methodCall, (AbstractInsnNode)this.getLabelNode(label));
            int insertionIndex = this.findCallSiteInvocationInsertionIndex(result.methodCall);
            if (insertionIndex < 0) {
                this.labels.add(label);
                this.nodes.add((AbstractInsnNode)result.methodCall);
                continue;
            }
            this.labels.add(insertionIndex, label);
            this.nodes.add(insertionIndex, (AbstractInsnNode)result.methodCall);
        }
    }

    boolean checkContinuableAnnotation(Collection<String> annotationDescriptors) {
        for (String annotationDescriptor : annotationDescriptors) {
            if (!this.cciResolver.isContinuableAnnotation(annotationDescriptor)) continue;
            return true;
        }
        return false;
    }

    int findCallSiteInvocationInsertionIndex(MethodInsnNode mnode) {
        int inSelected = -1;
        MethodInsnNode otherIns = mnode;
        while (otherIns != null && inSelected < 0) {
            if (!((otherIns = otherIns.getNext()) instanceof MethodInsnNode) && !(otherIns instanceof InvokeDynamicInsnNode)) continue;
            inSelected = this.nodes.indexOf(otherIns);
        }
        return inSelected;
    }

    void moveNew() throws AnalyzerException {
        SourceInterpreter i = new SourceInterpreter();
        Analyzer a = new Analyzer((Interpreter)i);
        a.analyze(this.className, (MethodNode)this);
        HashMap<AbstractInsnNode, MethodInsnNode> movable = new HashMap<AbstractInsnNode, MethodInsnNode>();
        Frame[] frames = a.getFrames();
        for (int j = 0; j < this.methods.size(); ++j) {
            MethodInsnNode mnode = this.methods.get(j);
            int n = this.instructions.indexOf((AbstractInsnNode)mnode);
            Frame f = frames[n];
            Type[] args = Type.getArgumentTypes((String)mnode.desc);
            SourceValue v = (SourceValue)f.getStack(f.getStackSize() - args.length - 1);
            Set insns = v.insns;
            for (AbstractInsnNode ins : insns) {
                AbstractInsnNode ins1;
                if (ins.getOpcode() == 187) {
                    movable.put(ins, mnode);
                    continue;
                }
                int n1 = this.instructions.indexOf(ins);
                if (ins.getOpcode() == 89) {
                    ins1 = this.instructions.get(n1 - 1);
                    if (ins1.getOpcode() != 187) continue;
                    movable.put(ins1, mnode);
                    continue;
                }
                if (ins.getOpcode() != 95) continue;
                ins1 = this.instructions.get(n1 - 1);
                AbstractInsnNode ins2 = this.instructions.get(n1 - 2);
                if (ins1.getOpcode() != 90 || ins2.getOpcode() != 187) continue;
                movable.put(ins2, mnode);
            }
        }
        int updateMaxStack = 0;
        for (Map.Entry e : movable.entrySet()) {
            Type type;
            int j;
            InsnList doNew;
            MethodInsnNode mnode;
            AbstractInsnNode node1 = (AbstractInsnNode)e.getKey();
            int n1 = this.instructions.indexOf(node1);
            AbstractInsnNode node2 = this.instructions.get(n1 + 1);
            AbstractInsnNode node3 = this.instructions.get(n1 + 2);
            int producer = node2.getOpcode();
            this.instructions.remove(node1);
            boolean requireDup = false;
            if (producer == 89) {
                this.instructions.remove(node2);
                requireDup = true;
            } else if (producer == 90) {
                this.instructions.remove(node2);
                this.instructions.remove(node3);
                requireDup = true;
            }
            MethodInsnNode nm = mnode = (MethodInsnNode)e.getValue();
            int varOffset = this.stackRecorderVar + 1;
            Type[] args = Type.getArgumentTypes((String)mnode.desc);
            if (args.length == 0) {
                doNew = new InsnList();
                doNew.add(node1);
                if (requireDup) {
                    doNew.add((AbstractInsnNode)new InsnNode(89));
                }
                this.instructions.insertBefore((AbstractInsnNode)nm, doNew);
                nm = doNew.getLast();
                continue;
            }
            if (args.length == 1 && args[0].getSize() == 1) {
                doNew = new InsnList();
                doNew.add(node1);
                if (requireDup) {
                    doNew.add((AbstractInsnNode)new InsnNode(89));
                    doNew.add((AbstractInsnNode)new InsnNode(93));
                    doNew.add((AbstractInsnNode)new InsnNode(88));
                    updateMaxStack = updateMaxStack < 2 ? 2 : updateMaxStack;
                } else {
                    doNew.add((AbstractInsnNode)new InsnNode(95));
                }
                this.instructions.insertBefore((AbstractInsnNode)nm, doNew);
                nm = doNew.getLast();
                continue;
            }
            if (args.length == 1 && args[0].getSize() == 2 || args.length == 2 && args[0].getSize() == 1 && args[1].getSize() == 1) {
                doNew = new InsnList();
                doNew.add(node1);
                if (requireDup) {
                    doNew.add((AbstractInsnNode)new InsnNode(89));
                    doNew.add((AbstractInsnNode)new InsnNode(94));
                    doNew.add((AbstractInsnNode)new InsnNode(88));
                    updateMaxStack = updateMaxStack < 2 ? 2 : updateMaxStack;
                } else {
                    doNew.add((AbstractInsnNode)new InsnNode(91));
                    doNew.add((AbstractInsnNode)new InsnNode(87));
                    updateMaxStack = updateMaxStack < 1 ? 1 : updateMaxStack;
                }
                this.instructions.insertBefore((AbstractInsnNode)nm, doNew);
                nm = doNew.getLast();
                continue;
            }
            doNew = new InsnList();
            for (j = args.length - 1; j >= 0; --j) {
                type = args[j];
                doNew.add((AbstractInsnNode)new VarInsnNode(type.getOpcode(54), varOffset));
                varOffset += type.getSize();
            }
            if (varOffset > this.maxLocals) {
                this.maxLocals = varOffset;
            }
            doNew.add(node1);
            if (requireDup) {
                doNew.add((AbstractInsnNode)new InsnNode(89));
            }
            for (j = 0; j < args.length; ++j) {
                type = args[j];
                doNew.add((AbstractInsnNode)new VarInsnNode(type.getOpcode(21), varOffset -= type.getSize()));
                if (type.getSort() != 10 && type.getSort() != 9) continue;
                updateMaxStack = updateMaxStack < 1 ? 1 : updateMaxStack;
                doNew.add((AbstractInsnNode)new InsnNode(1));
                doNew.add((AbstractInsnNode)new VarInsnNode(type.getOpcode(54), varOffset));
            }
            this.instructions.insertBefore((AbstractInsnNode)nm, doNew);
            nm = doNew.getLast();
        }
        this.maxStack += updateMaxStack;
    }

    boolean needsFrameGuard(int opcode, String owner, String name, String desc) {
        if (owner.startsWith("java/") || owner.startsWith("javax/")) {
            return false;
        }
        if (CONTINUATION_CLASS_INTERNAL_NAME.equals(owner)) {
            return CONTINUATION_CLASS_CONTINUABLE_METHODS.contains(name);
        }
        if (opcode == 183 && "<init>".equals(name)) {
            return false;
        }
        if (opcode == 186) {
            return true;
        }
        if (opcode == 185 || opcode == 183 || opcode == 184 || opcode == 182) {
            ContinuableClassInfo classInfo;
            try {
                classInfo = this.cciResolver.resolve(owner);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            return null != classInfo && classInfo.isContinuableMethod(opcode, name, desc, desc);
        }
        return false;
    }
}

