/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.javaflow.providers.asm5;

import org.apache.commons.javaflow.providers.asm5.ContinuableMethodNode;
import org.apache.commons.javaflow.spi.ContinuableClassInfo;
import org.apache.commons.javaflow.spi.ContinuableClassInfoResolver;
import org.apache.commons.javaflow.spi.StopException;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;

public class ContinuableClassVisitor
extends ClassVisitor {
    private final ContinuableClassInfoResolver cciResolver;
    private final byte[] originalBytes;
    private String className;
    private ContinuableClassInfo classInfo;
    private boolean skipEnchancing = false;
    private boolean isInterface = false;

    public ContinuableClassVisitor(ClassVisitor cv, ContinuableClassInfoResolver cciResolver, byte[] originalBytes) {
        super(327680, cv);
        this.cciResolver = cciResolver;
        this.originalBytes = originalBytes;
    }

    boolean skipEnchancing() {
        return this.skipEnchancing;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.isInterface = (access & 0x200) != 0;
        this.className = name;
        this.classInfo = this.cciResolver.resolve(name, this.originalBytes);
        if (null == this.classInfo || this.classInfo.isClassProcessed() || StopException.__dirtyCheckSkipContinuationsOnClass((int)version, (int)access, (String)name, (String)signature, (String)superName, (String[])interfaces)) {
            this.skipEnchancing = true;
            throw StopException.INSTANCE;
        }
        this.cv.visit(version, access, name, signature, superName, interfaces);
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        if ("___$$$CONT$$$___".equals(name) && (access & 8) != 0) {
            this.skipEnchancing = true;
            this.classInfo.markClassProcessed();
            throw StopException.INSTANCE;
        }
        return super.visitField(access, name, desc, signature, value);
    }

    public void visitEnd() {
        if (!this.skipEnchancing) {
            super.visitField((this.isInterface ? 1 : 2) + 16 + 8, "___$$$CONT$$$___", "Ljava/lang/String;", null, (Object)"A").visitEnd();
        }
        super.visitEnd();
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        boolean skip;
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        boolean bl = skip = this.skipEnchancing || null == this.classInfo || mv == null || (access & 0x500) > 0 || "<init>".equals(name) || !this.classInfo.isContinuableMethod(access, name, desc, signature);
        if (skip) {
            return mv;
        }
        return new ContinuableMethodNode(access, name, desc, signature, exceptions, this.className, this.cciResolver, mv);
    }
}

