/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.javaflow.examples.jee;

import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.json.Json;
import javax.json.JsonObject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.commons.javaflow.api.Continuation;
import org.apache.commons.javaflow.examples.jee.Execution;
import org.apache.commons.javaflow.examples.jee.ExecutionOuter;

@Stateless
@Path(value="/")
@Consumes(value={"application/json", "application/xml"})
public class ContinuableEchoService {
    @Inject
    Execution execution;
    @Inject
    ExecutionOuter executionOuter;

    @GET
    @Path(value="simple/{key}")
    @Produces(value={"application/json"})
    public JsonObject executeSimple(@PathParam(value="key") String key) {
        Object valueFromContinuation;
        StringBuilder result = new StringBuilder();
        for (Continuation cc = Continuation.startWith((Runnable)this.execution); null != cc; cc = cc.resume(valueFromContinuation)) {
            valueFromContinuation = cc.value();
            result.append("\nInterrupted " + key + " " + valueFromContinuation);
        }
        return Json.createObjectBuilder().add("message", result.toString()).build();
    }

    @GET
    @Path(value="nested/{key}")
    @Produces(value={"application/json"})
    public JsonObject executeNested(@PathParam(value="key") String key) {
        Object valueFromContinuation;
        StringBuilder result = new StringBuilder();
        for (Continuation cc = Continuation.startWith((Runnable)this.executionOuter); null != cc; cc = cc.resume(valueFromContinuation)) {
            valueFromContinuation = cc.value();
            result.append("\nInterrupted " + key + " " + valueFromContinuation);
        }
        return Json.createObjectBuilder().add("message", result.toString()).build();
    }
}

