/*
 * Decompiled with CFR 0.152.
 */
package net.tascalate.async.tools.maven;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import net.tascalate.async.tools.core.AsyncAwaitClassFileGenerator;
import net.tascalate.async.tools.core.ToolsHelper;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="tascalate-async-enhance", threadSafe=true, defaultPhase=LifecyclePhase.PROCESS_CLASSES, requiresDependencyResolution=ResolutionScope.TEST)
public class AsyncAwaitEnhancerMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", property="tascalate-async.enhancer.project", required=true, readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="false", property="tascalate-async.enhancer.skip", required=false)
    private boolean skip;
    @Parameter(defaultValue="true", property="tascalate-async.enhancer.includeTestClasses", required=true)
    private Boolean includeTestClasses;
    @Parameter(property="tascalate-async.enhancer.buildDir", required=false)
    private String buildDir;
    @Parameter(property="tascalate-async.enhancer.testBuildDir", required=false)
    private String testBuildDir;
    @Component
    private MojoExecution execution;

    public void execute() throws MojoExecutionException {
        Log log = this.getLog();
        if (this.skip) {
            log.info((CharSequence)"Skipping executing.");
            return;
        }
        try {
            File mainInputDirectory;
            File file = mainInputDirectory = this.buildDir == null ? new File(this.project.getBuild().getOutputDirectory()) : this.computeDir(this.buildDir);
            if (mainInputDirectory.exists()) {
                this.instrument(mainInputDirectory, this.project.getRuntimeClasspathElements());
            } else {
                log.warn((CharSequence)"No main build output directory available, skip enhancing main classes");
            }
            if (this.includeTestClasses.booleanValue()) {
                File testInputDirectory;
                File file2 = testInputDirectory = this.testBuildDir == null ? new File(this.project.getBuild().getTestOutputDirectory()) : this.computeDir(this.testBuildDir);
                if (testInputDirectory.exists()) {
                    this.instrument(testInputDirectory, this.project.getTestClasspathElements());
                } else if ("process-test-classes".equals(this.execution.getLifecyclePhase())) {
                    log.warn((CharSequence)"No test build output directory available, skip enhancing test classes");
                }
            }
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)e.getMessage(), (Throwable)e);
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    private void instrument(File inputDirectory, List<String> classPathEntries) throws IOException {
        Log log = this.getLog();
        ArrayList<URL> classPath = new ArrayList<URL>();
        for (String classPathEntry : classPathEntries) {
            classPath.add(this.resolveUrl(new File(classPathEntry)));
        }
        classPath.add(this.resolveUrl(inputDirectory));
        ToolsHelper.transformFiles((File)inputDirectory, (AsyncAwaitClassFileGenerator)ToolsHelper.createGenerator(classPath), arg_0 -> ((Log)log).debug(arg_0), arg_0 -> ((Log)log).info(arg_0));
    }

    private File computeDir(String dir) {
        File dirFile = new File(dir);
        if (dirFile.isAbsolute()) {
            return dirFile;
        }
        return new File(this.project.getBasedir(), this.buildDir).getAbsoluteFile();
    }

    private URL resolveUrl(File resource) {
        try {
            return resource.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public boolean isSkip() {
        return this.skip;
    }

    public Boolean getIncludeTestClasses() {
        return this.includeTestClasses;
    }

    public String getBuildDir() {
        return this.buildDir;
    }

    public String getTestBuildDir() {
        return this.testBuildDir;
    }
}

