/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.javaflow.spi;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.javaflow.spi.ClassHeaderReader;
import org.apache.commons.javaflow.spi.ClassMatchStrategy;
import org.apache.commons.javaflow.spi.ClassMatcher;
import org.apache.commons.javaflow.spi.FastByteArrayOutputStream;
import org.apache.commons.javaflow.spi.ResourceLoader;

public final class ClassMatchStrategies {
    public static final ClassMatchStrategy MATCH_NONE = new ClassMatchStrategy(){

        @Override
        public boolean matches(String name, String signature, String superName, String[] interfaces, ResourceLoader loader) {
            return false;
        }

        @Override
        public ClassMatcher bind(ResourceLoader ignore) {
            return ClassMatcher.MATCH_NONE;
        }
    };
    public static final ClassMatchStrategy MATCH_ALL = new ClassMatchStrategy(){

        @Override
        public boolean matches(String name, String signature, String superName, String[] interfaces, ResourceLoader loader) {
            return true;
        }

        @Override
        public ClassMatcher bind(ResourceLoader ignore) {
            return ClassMatcher.MATCH_ALL;
        }
    };

    private ClassMatchStrategies() {
    }

    public static ClassMatchStrategy whenAll(ClassMatchStrategy ... matchers) {
        return ClassMatchStrategies.whenAll(Arrays.asList(matchers));
    }

    public static ClassMatchStrategy whenAll(final Collection<? extends ClassMatchStrategy> matchers) {
        return new ClassMatchStrategy(){

            @Override
            public boolean matches(String name, String signature, String superName, String[] interfaces, ResourceLoader loader) {
                for (ClassMatchStrategy m : matchers) {
                    if (m.matches(name, signature, superName, interfaces, loader)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public static ClassMatchStrategy whenAny(ClassMatchStrategy ... matchers) {
        return ClassMatchStrategies.whenAny(Arrays.asList(matchers));
    }

    public static ClassMatchStrategy whenAny(final Collection<? extends ClassMatchStrategy> matchers) {
        return new ClassMatchStrategy(){

            @Override
            public boolean matches(String name, String signature, String superName, String[] interfaces, ResourceLoader loader) {
                for (ClassMatchStrategy m : matchers) {
                    if (!m.matches(name, signature, superName, interfaces, loader)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static ClassMatchStrategy negate(final ClassMatchStrategy matcher) {
        return new ClassMatchStrategy(){

            @Override
            public boolean matches(String name, String signature, String superName, String[] interfaces, ResourceLoader loader) {
                return !matcher.matches(name, signature, superName, interfaces, loader);
            }
        };
    }

    public static ClassMatchStrategy byClassName(String className, final boolean namePart) {
        final String cn = ClassMatchStrategies.className(className);
        return new ClassMatchStrategy(){

            @Override
            public boolean matches(String name, String signature, String superName, String[] interfaces, ResourceLoader loader) {
                return namePart && name.contains(cn) || name.equals(cn);
            }
        };
    }

    public static ClassMatchStrategy byClassNamePattern(String classNamePattern) {
        final Pattern pattern = Pattern.compile("^" + classNamePattern + "$");
        return new ClassMatchStrategy(){

            @Override
            public boolean matches(String name, String signature, String superName, String[] interfaces, ResourceLoader loader) {
                return pattern.matcher(name).matches();
            }
        };
    }

    public static ClassMatchStrategy bySuperClass(final ClassMatchStrategy nested) {
        return new ClassMatchStrategy(){

            @Override
            public boolean matches(String name, String signature, String superName, String[] interfaces, ResourceLoader loader) {
                String cname = superName;
                while (null != cname && cname.length() > 0) {
                    ClassHeaderReader chr;
                    try {
                        chr = ClassMatchStrategies.getClassHeader(loader, cname);
                    }
                    catch (IOException ex) {
                        throw new RuntimeException(ex);
                    }
                    String nextSuperName = chr.getSuperName();
                    if (nested.matches(cname, null, nextSuperName, chr.getInterfaces(), loader)) {
                        return true;
                    }
                    cname = nextSuperName;
                }
                return false;
            }
        };
    }

    public static ClassMatchStrategy byInterface(final ClassMatchStrategy nested) {
        return new ClassMatchStrategy(){

            @Override
            public boolean matches(String name, String signature, String superName, String[] interfaces, ResourceLoader loader) {
                if (null == interfaces || interfaces.length == 0) {
                    return false;
                }
                HashSet visited = new HashSet();
                for (String intf : interfaces) {
                    if (!ClassMatchStrategies.matchInterface(intf, nested, visited, loader)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    private static boolean matchInterface(String intf, ClassMatchStrategy nested, Set<String> visited, ResourceLoader loader) {
        String[] nextInterfaces;
        ClassHeaderReader chr;
        if (visited.contains(intf)) {
            return false;
        }
        try {
            chr = ClassMatchStrategies.getClassHeader(loader, intf);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        if (nested.matches(intf, null, chr.getSuperName(), chr.getInterfaces(), loader)) {
            return true;
        }
        visited.add(intf);
        for (String nextInterface : nextInterfaces = chr.getInterfaces()) {
            if (!ClassMatchStrategies.matchInterface(nextInterface, nested, visited, loader)) continue;
            return true;
        }
        return false;
    }

    private static String className(String internalClassName) {
        return internalClassName != null ? internalClassName.replace('.', '/') : null;
    }

    private static ClassHeaderReader getClassHeader(ResourceLoader loader, String className) throws IOException {
        return new ClassHeaderReader(ClassMatchStrategies.getClassBytes(loader, className));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] getClassBytes(ResourceLoader loader, String className) throws IOException, SecurityException {
        InputStream in = loader.getResourceAsStream(className + ".class");
        try {
            byte[] byArray = ClassMatchStrategies.getStreamBytes(in);
            return byArray;
        }
        finally {
            if (null != in) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] getStreamBytes(InputStream stream) throws IOException {
        int BUFFER_SIZE = 4096;
        FastByteArrayOutputStream baos = new FastByteArrayOutputStream(BUFFER_SIZE);
        try {
            byte[] data;
            int bytesRead;
            byte[] buffer = new byte[BUFFER_SIZE];
            while ((bytesRead = stream.read(buffer, 0, BUFFER_SIZE)) > 0) {
                baos.write(buffer, 0, bytesRead);
            }
            byte[] byArray = data = baos.unsafeBytes();
            return byArray;
        }
        finally {
            baos.close();
        }
    }
}

