/*
 * Decompiled with CFR 0.152.
 */
package net.tascalate.async.tools.gradle;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.tascalate.async.tools.core.AsyncAwaitClassFileGenerator;
import net.tascalate.async.tools.core.ToolsHelper;
import net.tascalate.async.tools.gradle.AsyncAwaitEnhancerPluginConfiguration;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.SourceSetOutput;

public class AsyncAwaitEnhancerPlugin
implements Plugin<Project> {
    private Logger log;

    public void apply(Project target) {
        AsyncAwaitEnhancerPluginConfiguration config = new AsyncAwaitEnhancerPluginConfiguration();
        target.getExtensions().add("async-await", (Object)config);
        this.log = target.getLogger();
        Set compileJavaTasks = target.getTasksByName("compileJava", true);
        for (Task task : compileJavaTasks) {
            this.addInstrumentActionToTask("main", task, config);
        }
        Set compileJavaTestTasks = target.getTasksByName("compileTestJava", true);
        for (Task task : compileJavaTestTasks) {
            this.addInstrumentActionToTask("test", task, config);
        }
    }

    private void addInstrumentActionToTask(final String sourceType, final Task task, final AsyncAwaitEnhancerPluginConfiguration config) {
        task.doLast((Action)new Action<Task>(){

            public void execute(Task arg0) {
                if (config.isSkip()) {
                    AsyncAwaitEnhancerPlugin.this.log.info("Skipping execution.");
                    return;
                }
                if ("test".equals(sourceType) && !config.isIncludeTestClasses()) {
                    AsyncAwaitEnhancerPlugin.this.log.info("Skipping execution on test classes.");
                    return;
                }
                try {
                    Project project = task.getProject();
                    SourceSetContainer sourceSetsContainer = (SourceSetContainer)project.getProperties().get("sourceSets");
                    SourceSet sourceSet = (SourceSet)sourceSetsContainer.getByName(sourceType);
                    if (null != sourceSet) {
                        Set compileClasspath = sourceSet.getCompileClasspath().getFiles();
                        SourceSetOutput output = sourceSet.getOutput();
                        Set classesDirs = output.getClassesDirs().getFiles();
                        AsyncAwaitEnhancerPlugin.this.instrument(classesDirs, compileClasspath, config);
                    }
                }
                catch (Exception e) {
                    AsyncAwaitEnhancerPlugin.this.log.log(LogLevel.ERROR, "Coroutines instrumentation failed", (Throwable)e);
                    throw new IllegalStateException("Coroutines instrumentation failed", e);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void instrument(Set<File> classesDirs, Set<File> compileClasspath, AsyncAwaitEnhancerPluginConfiguration config) {
        try {
            this.log.debug("Getting compile classpath");
            ArrayList<URL> classPath = new ArrayList<URL>();
            classPath.addAll(this.urlsOf(classesDirs));
            classPath.addAll(this.urlsOf(compileClasspath));
            this.log.debug("Classpath for instrumentation is as follows: " + classPath);
            AsyncAwaitClassFileGenerator generator = ToolsHelper.createGenerator(classPath);
            try {
                for (File inputDir : classesDirs) {
                    if (!inputDir.isDirectory()) continue;
                    ToolsHelper.transformFiles(inputDir, generator, arg_0 -> this.log.debug(arg_0), arg_0 -> this.log.info(arg_0));
                }
            }
            finally {
                generator.reset();
            }
        }
        catch (IOException ex) {
            throw new IllegalStateException("Failed to instrument", ex);
        }
    }

    private List<URL> urlsOf(Set<File> files) {
        if (null == files) {
            return Collections.emptyList();
        }
        ArrayList<URL> result = new ArrayList<URL>();
        for (File file : files) {
            URL url = this.resolveUrl(file);
            if (null == url) continue;
            result.add(url);
        }
        return result.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(result);
    }

    private URL resolveUrl(File resource) {
        try {
            return resource.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

