/*
 * Decompiled with CFR 0.152.
 */
package net.tascalate.async.tools.core;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.tascalate.async.tools.core.AsyncAwaitClassFileGenerator;
import org.apache.commons.javaflow.spi.ClasspathResourceLoader;
import org.apache.commons.javaflow.spi.RecursiveFilesIterator;

public class ToolsHelper {
    public static AsyncAwaitClassFileGenerator createGenerator(List<URL> classPath) {
        ClassLoader effectiveClassLoader = ToolsHelper.loadAdditionalClassPath(classPath);
        return new AsyncAwaitClassFileGenerator(new ClasspathResourceLoader(effectiveClassLoader));
    }

    private static ClassLoader loadAdditionalClassPath(List<URL> classPath) {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        if (null == contextClassLoader) {
            contextClassLoader = ClassLoader.getSystemClassLoader();
        }
        if (classPath.isEmpty()) {
            return contextClassLoader;
        }
        URLClassLoader pluginClassLoader = URLClassLoader.newInstance(classPath.toArray(new URL[classPath.size()]), contextClassLoader);
        return pluginClassLoader;
    }

    public static void transformFiles(File inputDirectory, AsyncAwaitClassFileGenerator generator, Consumer<String> debug, Consumer<String> info) throws IOException {
        long now = System.currentTimeMillis();
        for (File source : RecursiveFilesIterator.scanClassFiles(inputDirectory)) {
            if (source.lastModified() > now) continue;
            debug.accept("Applying async/await support: " + source);
            boolean rewritten = ToolsHelper.rewriteClassFile(source, generator, source);
            if (!rewritten) continue;
            info.accept("Rewritten async-enabled class file: " + source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean rewriteClassFile(File source, AsyncAwaitClassFileGenerator generator, File target) throws IOException {
        byte[] original = ToolsHelper.toByteArray(source);
        try {
            byte[] transformed = generator.transform(original);
            if (transformed != original || !source.equals(target)) {
                ToolsHelper.writeFile(target, transformed != null ? transformed : original);
                if (transformed != original) {
                    Map<String, byte[]> extraClasses = generator.getGeneratedClasses();
                    for (Map.Entry<String, byte[]> e : ToolsHelper.renameInMemoryResources(extraClasses).entrySet()) {
                        ToolsHelper.writeFile(new File(target.getParentFile(), e.getKey()), e.getValue());
                    }
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (null != generator) {
                generator.reset();
            }
        }
    }

    private static Map<String, byte[]> renameInMemoryResources(Map<String, byte[]> generatedClasses) {
        HashMap<String, byte[]> resources = new HashMap<String, byte[]>();
        for (Map.Entry<String, byte[]> e : generatedClasses.entrySet()) {
            String name = e.getKey();
            int idx = name.lastIndexOf(47);
            if (idx >= 0 && idx < name.length() - 1) {
                name = name.substring(idx + 1);
            }
            resources.put(name + ".class", e.getValue());
        }
        return resources;
    }

    private static void writeFile(File target, byte[] content) throws IOException {
        Files.write(target.toPath(), content, new OpenOption[0]);
    }

    private static byte[] toByteArray(File source) throws IOException {
        return Files.readAllBytes(source.toPath());
    }
}

