/*
 * Decompiled with CFR 0.152.
 */
package net.tascalate.async.tools.core;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.tascalate.asmx.Type;
import net.tascalate.asmx.tree.AnnotationNode;
import net.tascalate.asmx.tree.ClassNode;
import net.tascalate.asmx.tree.FieldNode;
import net.tascalate.asmx.tree.InnerClassNode;
import net.tascalate.asmx.tree.MethodNode;
import net.tascalate.asmx.tree.TryCatchBlockNode;
import net.tascalate.asmx.tree.TypeAnnotationNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BytecodeIntrospection {
    private static final Logger log = LoggerFactory.getLogger(BytecodeIntrospection.class);
    static final String ASYNC_ANNOTATION_DESCRIPTOR = "Lnet/tascalate/async/async;";

    private BytecodeIntrospection() {
    }

    static String getMethodSignature(MethodNode methodNode, boolean outputExceptions) {
        StringBuilder result = new StringBuilder();
        int access = methodNode.access;
        if ((access & 1) != 0) {
            result.append("public ");
        }
        if ((access & 4) != 0) {
            result.append("protected ");
        }
        if ((access & 2) != 0) {
            result.append("private ");
        }
        if ((access & 0x400) != 0) {
            result.append("abstract ");
        }
        if ((access & 0x10) != 0) {
            result.append("final ");
        }
        if ((access & 8) != 0) {
            result.append("static ");
        }
        if ((access & 0x800) != 0) {
            result.append("strictfp ");
        }
        if ((access & 0x20) != 0) {
            result.append("synchronized ");
        }
        result.append(Type.getReturnType(methodNode.desc).getClassName()).append(' ');
        result.append(methodNode.name);
        result.append('(');
        result.append(Arrays.stream(Type.getArgumentTypes(methodNode.desc)).map(t -> t.getClassName()).collect(Collectors.joining(", ")));
        result.append(')');
        if (outputExceptions && null != methodNode.exceptions && !methodNode.exceptions.isEmpty()) {
            result.append(" throws ");
            List<String> exceptions = methodNode.exceptions;
            result.append(exceptions.stream().map(v -> v.toString().replace('/', '.')).collect(Collectors.joining(", ")));
        }
        return result.toString();
    }

    static boolean isLoadOpcode(int opcode) {
        return opcode >= 21 && opcode < 54;
    }

    static boolean isAsyncMethod(MethodNode methodNode) {
        return BytecodeIntrospection.hasAsyncAnnotation(methodNode);
    }

    static List<MethodNode> methodsOf(ClassNode classNode) {
        return null == classNode.methods ? Collections.emptyList() : classNode.methods;
    }

    static List<InnerClassNode> innerClassesOf(ClassNode classNode) {
        return null == classNode.innerClasses ? Collections.emptyList() : classNode.innerClasses;
    }

    static String createInnerClassName(ClassNode classNode) {
        String name;
        int index = 1;
        while (BytecodeIntrospection.hasInnerClass(classNode, name = BytecodeIntrospection.createInnerClassName(classNode, index))) {
            ++index;
        }
        if (log.isDebugEnabled()) {
            log.debug("Generated new inner class name: " + name);
        }
        return name;
    }

    static String createAccessMethodName(List<MethodNode> methods) {
        String name;
        int index = 0;
        while (BytecodeIntrospection.hasMethod(name = BytecodeIntrospection.createAccessMethodName(index), methods)) {
            ++index;
        }
        if (log.isDebugEnabled()) {
            log.trace("Generated new method name: " + name);
        }
        return name;
    }

    static String createOuterClassMethodArgFieldName(int index) {
        return "val$" + index;
    }

    static MethodNode getMethod(String methodName, String methodDesc, List<MethodNode> methods) {
        for (MethodNode methodNode : methods) {
            if (!methodName.equals(methodNode.name) || methodDesc != null && !methodDesc.equals(methodNode.desc)) continue;
            return methodNode;
        }
        return null;
    }

    static FieldNode getField(ClassNode classNode, String fieldName, String fieldDesc) {
        for (FieldNode fieldNode : BytecodeIntrospection.fieldsOf(classNode)) {
            if (!fieldName.equals(fieldNode.name) || fieldDesc != null && !fieldDesc.equals(fieldNode.desc)) continue;
            return fieldNode;
        }
        return null;
    }

    private static String createInnerClassName(ClassNode classNode, int index) {
        return classNode.name + "$" + index;
    }

    private static String createAccessMethodName(int index) {
        return "access$" + index;
    }

    private static boolean hasInnerClass(ClassNode classNode, String innerClassName) {
        return BytecodeIntrospection.getInnerClass(classNode, innerClassName) != null;
    }

    private static InnerClassNode getInnerClass(ClassNode classNode, String innerClassName) {
        for (InnerClassNode icn : BytecodeIntrospection.innerClassesOf(classNode)) {
            if (!innerClassName.equals(icn.name)) continue;
            return icn;
        }
        return null;
    }

    private static boolean hasAsyncAnnotation(MethodNode methodNode) {
        boolean found;
        boolean bl = found = BytecodeIntrospection.annotationPresent(BytecodeIntrospection.invisibleAnnotationsOf(methodNode), ASYNC_ANNOTATION_DESCRIPTOR) || BytecodeIntrospection.annotationPresent(BytecodeIntrospection.visibleAnnotationsOf(methodNode), ASYNC_ANNOTATION_DESCRIPTOR);
        if (found && log.isDebugEnabled()) {
            log.debug("@Async annotation found, method: " + methodNode);
        }
        return found;
    }

    private static boolean annotationPresent(List<AnnotationNode> annotations, String targetAnnotationTypeDescriptor) {
        for (AnnotationNode annotation : annotations) {
            if (!targetAnnotationTypeDescriptor.equals(annotation.desc)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasMethod(String methodName, List<MethodNode> methods) {
        return BytecodeIntrospection.getMethod(methodName, null, methods) != null;
    }

    private static List<FieldNode> fieldsOf(ClassNode classNode) {
        return null == classNode.fields ? Collections.emptyList() : classNode.fields;
    }

    static List<AnnotationNode> visibleAnnotationsOf(MethodNode methodNode) {
        return BytecodeIntrospection.safeAnnotationsList(methodNode.visibleAnnotations);
    }

    static List<AnnotationNode>[] visibleParameterAnnotationsOf(MethodNode methodNode) {
        return methodNode.visibleParameterAnnotations;
    }

    static List<TypeAnnotationNode> visibleTypeAnnotationsOf(MethodNode methodNode) {
        return BytecodeIntrospection.safeAnnotationsList(methodNode.visibleTypeAnnotations);
    }

    static List<TypeAnnotationNode> visibleTypeAnnotationsOf(TryCatchBlockNode tryCatchBlockNode) {
        return BytecodeIntrospection.safeAnnotationsList(tryCatchBlockNode.visibleTypeAnnotations);
    }

    static List<AnnotationNode> invisibleAnnotationsOf(MethodNode methodNode) {
        return BytecodeIntrospection.safeAnnotationsList(methodNode.invisibleAnnotations);
    }

    static List<AnnotationNode>[] invisibleParameterAnnotationsOf(MethodNode methodNode) {
        return methodNode.invisibleParameterAnnotations;
    }

    static List<TypeAnnotationNode> invisibleTypeAnnotationsOf(MethodNode methodNode) {
        return BytecodeIntrospection.safeAnnotationsList(methodNode.invisibleTypeAnnotations);
    }

    static List<TypeAnnotationNode> invisibleTypeAnnotationsOf(TryCatchBlockNode tryCatchBlockNode) {
        return BytecodeIntrospection.safeAnnotationsList(tryCatchBlockNode.invisibleTypeAnnotations);
    }

    private static <T> List<T> safeAnnotationsList(List<?> annotations) {
        return null == annotations ? Collections.emptyList() : annotations;
    }
}

