/*
 * Decompiled with CFR 0.152.
 */
package net.tascalate.async.tools.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.tascalate.asmx.Handle;
import net.tascalate.asmx.MethodVisitor;
import net.tascalate.asmx.Type;
import net.tascalate.asmx.tree.AbstractInsnNode;
import net.tascalate.asmx.tree.ClassNode;
import net.tascalate.asmx.tree.FieldInsnNode;
import net.tascalate.asmx.tree.FieldNode;
import net.tascalate.asmx.tree.IincInsnNode;
import net.tascalate.asmx.tree.InsnList;
import net.tascalate.asmx.tree.InsnNode;
import net.tascalate.asmx.tree.IntInsnNode;
import net.tascalate.asmx.tree.InvokeDynamicInsnNode;
import net.tascalate.asmx.tree.JumpInsnNode;
import net.tascalate.asmx.tree.LabelNode;
import net.tascalate.asmx.tree.MethodInsnNode;
import net.tascalate.asmx.tree.MethodNode;
import net.tascalate.asmx.tree.TryCatchBlockNode;
import net.tascalate.asmx.tree.VarInsnNode;
import net.tascalate.async.tools.core.AbstractAsyncMethodTransformer;
import net.tascalate.async.tools.core.BytecodeIntrospection;
import net.tascalate.async.tools.core.BytecodeTraceUtil;

class AsyncGeneratorMethodTransformer
extends AbstractAsyncMethodTransformer {
    private static final Type ASYNC_GENERATOR_METHOD_TYPE = Type.getObjectType("net/tascalate/async/core/AsyncGeneratorMethod");
    private static final Type LAZY_GENERATOR_TYPE = Type.getObjectType("net/tascalate/async/core/LazyGenerator");

    AsyncGeneratorMethodTransformer(ClassNode classNode, MethodNode originalAsyncMethodNode, Map<String, MethodNode> accessMethods, AbstractAsyncMethodTransformer.Helper helper) {
        super(classNode, originalAsyncMethodNode, accessMethods, helper);
    }

    @Override
    protected ClassNode transform() {
        return this.transform(ASYNC_GENERATOR_METHOD_TYPE);
    }

    @Override
    protected MethodVisitor createReplacementAsyncMethod(String asyncTaskClassName) {
        return this.createReplacementAsyncMethod(asyncTaskClassName, ASYNC_GENERATOR_METHOD_TYPE, "generator", LAZY_GENERATOR_TYPE);
    }

    @Override
    protected MethodVisitor addAnonymousClassRunMethod(ClassNode asyncRunnableClass, FieldNode outerClassField) {
        List<MethodNode> ownerMethods = BytecodeIntrospection.methodsOf(this.classNode);
        boolean isStatic = (this.originalAsyncMethod.access & 8) != 0;
        int thisShiftNecessary = isStatic ? 1 : 0;
        Type[] originalArgTypes = Type.getArgumentTypes(this.originalAsyncMethod.desc);
        if (log.isTraceEnabled()) {
            log.trace("Method has " + originalArgTypes.length + " arguments");
        }
        MethodNode result = (MethodNode)asyncRunnableClass.visitMethod(4, "doRun", "()V", null, new String[]{"java/lang/Throwable"});
        result.visitAnnotation(SUSPENDABLE_ANNOTATION_TYPE.getDescriptor(), true);
        LabelNode methodStart = new LabelNode();
        LabelNode methodEnd = new LabelNode();
        IdentityHashMap<LabelNode, LabelNode> labelsMap = new IdentityHashMap<LabelNode, LabelNode>();
        for (AbstractInsnNode l = this.originalAsyncMethod.instructions.getFirst(); l != null; l = l.getNext()) {
            if (!(l instanceof LabelNode)) continue;
            labelsMap.put((LabelNode)l, new LabelNode());
        }
        ArrayList<TryCatchBlockNode> tryCatchBlocks = new ArrayList<TryCatchBlockNode>();
        for (TryCatchBlockNode tn : this.originalAsyncMethod.tryCatchBlocks) {
            TryCatchBlockNode newTn = new TryCatchBlockNode((LabelNode)labelsMap.get(tn.start), (LabelNode)labelsMap.get(tn.end), (LabelNode)labelsMap.get(tn.handler), tn.type);
            newTn.invisibleTypeAnnotations = AsyncGeneratorMethodTransformer.copyTypeAnnotations(BytecodeIntrospection.invisibleTypeAnnotationsOf(tn));
            newTn.visibleTypeAnnotations = AsyncGeneratorMethodTransformer.copyTypeAnnotations(BytecodeIntrospection.visibleTypeAnnotationsOf(tn));
            tryCatchBlocks.add(newTn);
        }
        result.tryCatchBlocks = tryCatchBlocks;
        InsnList newInstructions = new InsnList();
        newInstructions.add(methodStart);
        int argumentsLength = Arrays.stream(originalArgTypes).mapToInt(a -> a.getSize()).sum();
        block20: for (AbstractInsnNode insn = this.originalAsyncMethod.instructions.getFirst(); null != insn; insn = insn.getNext()) {
            String argDesc;
            Object argType;
            if (insn instanceof VarInsnNode) {
                VarInsnNode vin = (VarInsnNode)insn;
                if (!isStatic && vin.getOpcode() == 25 && vin.var == 0) {
                    if (log.isTraceEnabled()) {
                        log.trace("Found " + BytecodeTraceUtil.toString(vin));
                    }
                    newInstructions.add(new VarInsnNode(25, 0));
                    newInstructions.add(new FieldInsnNode(180, asyncRunnableClass.name, outerClassField.name, outerClassField.desc));
                    continue;
                }
                if (vin.getOpcode() != 169 && (vin.var > 0 || isStatic)) {
                    int argIdx;
                    if (log.isTraceEnabled()) {
                        log.trace("Found " + BytecodeTraceUtil.toString(vin));
                    }
                    Object object = argType = (argIdx = AsyncGeneratorMethodTransformer.findOriginalArgumentIndex(originalArgTypes, vin.var, isStatic)) < 0 ? null : originalArgTypes[argIdx];
                    if (null != argType) {
                        String argName = BytecodeIntrospection.createOuterClassMethodArgFieldName(argIdx);
                        argDesc = ((Type)argType).getDescriptor();
                        newInstructions.add(new VarInsnNode(25, 0));
                        if (BytecodeIntrospection.isLoadOpcode(vin.getOpcode())) {
                            assert (((Type)argType).getOpcode(21) == vin.getOpcode()) : "Wrong opcode " + vin.getOpcode() + ", expected " + ((Type)argType).getOpcode(21);
                            newInstructions.add(new FieldInsnNode(180, asyncRunnableClass.name, argName, argDesc));
                            continue;
                        }
                        assert (((Type)argType).getOpcode(54) == vin.getOpcode()) : "Wrong opcode " + vin.getOpcode() + ", expected " + ((Type)argType).getOpcode(54);
                        if (((Type)argType).getSize() == 2) {
                            newInstructions.add(new InsnNode(91));
                            newInstructions.add(new InsnNode(87));
                        } else {
                            newInstructions.add(new InsnNode(95));
                        }
                        newInstructions.add(new FieldInsnNode(181, asyncRunnableClass.name, argName, argDesc));
                        continue;
                    }
                    newInstructions.add(new VarInsnNode(vin.getOpcode(), vin.var - argumentsLength + thisShiftNecessary));
                    continue;
                }
            } else {
                if (insn instanceof IincInsnNode) {
                    IincInsnNode iins = (IincInsnNode)insn;
                    int argIdx = AsyncGeneratorMethodTransformer.findOriginalArgumentIndex(originalArgTypes, iins.var, isStatic);
                    Object object = argType = argIdx < 0 ? null : originalArgTypes[argIdx];
                    if (null != argType) {
                        String argName = BytecodeIntrospection.createOuterClassMethodArgFieldName(argIdx);
                        argDesc = ((Type)argType).getDescriptor();
                        newInstructions.add(new VarInsnNode(25, 0));
                        newInstructions.add(new FieldInsnNode(180, asyncRunnableClass.name, argName, argDesc));
                        newInstructions.add(new IntInsnNode(17, iins.incr));
                        newInstructions.add(new InsnNode(96));
                        newInstructions.add(new VarInsnNode(25, 0));
                        newInstructions.add(new InsnNode(95));
                        newInstructions.add(new FieldInsnNode(181, asyncRunnableClass.name, argName, argDesc));
                        continue;
                    }
                    newInstructions.add(new IincInsnNode(iins.var - argumentsLength + thisShiftNecessary, iins.incr));
                    continue;
                }
                if (insn instanceof FieldInsnNode) {
                    MethodNode accessMethod;
                    FieldInsnNode fin = (FieldInsnNode)insn;
                    if ((fin.getOpcode() == 178 || fin.getOpcode() == 180) && (accessMethod = this.getAccessMethod(fin.owner, fin.name, fin.desc, "G")) != null) {
                        newInstructions.add(new MethodInsnNode(184, this.classNode.name, accessMethod.name, accessMethod.desc, false));
                        continue;
                    }
                    if ((fin.getOpcode() == 179 || fin.getOpcode() == 181) && (accessMethod = this.getAccessMethod(fin.owner, fin.name, fin.desc, "S")) != null) {
                        newInstructions.add(new MethodInsnNode(184, this.classNode.name, accessMethod.name, accessMethod.desc, false));
                        continue;
                    }
                } else if (insn instanceof MethodInsnNode) {
                    MethodNode accessMethod;
                    MethodInsnNode min = (MethodInsnNode)insn;
                    if ((min.getOpcode() == 182 || min.getOpcode() == 183 || min.getOpcode() == 184) && (accessMethod = this.getAccessMethod(min.owner, min.name, min.desc, "M")) != null) {
                        if (log.isTraceEnabled()) {
                            log.trace("Found " + BytecodeTraceUtil.toString(min));
                        }
                        newInstructions.add(new MethodInsnNode(184, this.classNode.name, accessMethod.name, accessMethod.desc, (this.classNode.access & 0x200) != 0));
                        continue;
                    }
                    if (min.getOpcode() == 184 && "net/tascalate/async/CallContext".equals(min.owner)) {
                        switch (min.name) {
                            case "yield": {
                                Type[] args = Type.getArgumentTypes(min.desc);
                                newInstructions.add(new VarInsnNode(25, 0));
                                if (null != args) {
                                    switch (args.length) {
                                        case 0: {
                                            break;
                                        }
                                        case 1: {
                                            newInstructions.add(new InsnNode(95));
                                            break;
                                        }
                                        default: {
                                            throw new IllegalStateException("Can't support YIELD method with more than one argument");
                                        }
                                    }
                                }
                                newInstructions.add(new MethodInsnNode(182, ASYNC_GENERATOR_METHOD_TYPE.getInternalName(), "yield", Type.getMethodDescriptor(Type.getReturnType(min.desc), args), false));
                                continue block20;
                            }
                            case "interrupted": {
                                newInstructions.add(new VarInsnNode(25, 0));
                                newInstructions.add(new MethodInsnNode(182, ASYNC_GENERATOR_METHOD_TYPE.getInternalName(), "interrupted", Type.getMethodDescriptor(Type.BOOLEAN_TYPE, new Type[0]), false));
                                continue block20;
                            }
                            case "await": {
                                newInstructions.add(new MethodInsnNode(184, ASYNC_METHOD_EXECUTOR_TYPE.getInternalName(), "await", Type.getMethodDescriptor(OBJECT_TYPE, COMPLETION_STAGE_TYPE), false));
                                continue block20;
                            }
                            case "throwing": {
                                int exceptionTypesCount;
                                for (int i = exceptionTypesCount = Type.getArgumentTypes(min.desc).length; i > 0; --i) {
                                    newInstructions.add(new InsnNode(87));
                                }
                                continue block20;
                            }
                            case "async": {
                                throw new IllegalStateException("Async result must be used only inside non-generator methods");
                            }
                        }
                    }
                } else if (insn instanceof InvokeDynamicInsnNode) {
                    Object[] opts = this.findOwnerInvokeDynamic(insn, ownerMethods);
                    if (null != opts) {
                        Handle h = (Handle)opts[0];
                        MethodNode lambdaAccess = this.getAccessMethod(h.getOwner(), h.getName(), h.getDesc(), "L");
                        newInstructions.add(new MethodInsnNode(184, this.classNode.name, lambdaAccess.name, lambdaAccess.desc, (this.classNode.access & 0x200) != 0));
                        continue;
                    }
                } else {
                    if (insn.getOpcode() == 176) {
                        newInstructions.add(new JumpInsnNode(167, methodEnd));
                        continue;
                    }
                    if (insn instanceof LabelNode) {
                        newInstructions.add((AbstractInsnNode)labelsMap.get(insn));
                        continue;
                    }
                }
            }
            newInstructions.add(insn.clone(labelsMap));
        }
        newInstructions.add(methodEnd);
        newInstructions.add(new InsnNode(87));
        newInstructions.add(new InsnNode(177));
        result.instructions = newInstructions;
        result.maxLocals = Math.max(this.originalAsyncMethod.maxLocals - argumentsLength + thisShiftNecessary, 2);
        result.maxStack = Math.max(this.originalAsyncMethod.maxStack, 2);
        return result;
    }
}

