/*
 * Decompiled with CFR 0.152.
 */
package net.tascalate.async.tools.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.tascalate.asmx.ClassReader;
import net.tascalate.asmx.ClassVisitor;
import net.tascalate.asmx.Type;
import net.tascalate.asmx.plus.ClassHierarchy;
import net.tascalate.asmx.plus.OfflineClassWriter;
import net.tascalate.asmx.tree.ClassNode;
import net.tascalate.asmx.tree.MethodNode;
import net.tascalate.asmx.util.CheckClassAdapter;
import net.tascalate.asmx.util.TraceClassVisitor;
import net.tascalate.async.tools.core.AbstractAsyncMethodTransformer;
import net.tascalate.async.tools.core.AsmxResourceLoader;
import net.tascalate.async.tools.core.AsyncGeneratorMethodTransformer;
import net.tascalate.async.tools.core.AsyncTaskMethodTransformer;
import net.tascalate.async.tools.core.BytecodeIntrospection;
import net.tascalate.async.tools.core.BytecodeTraceUtil;
import org.apache.commons.javaflow.spi.ResourceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncAwaitClassFileGenerator {
    private static final Logger log = LoggerFactory.getLogger(AsyncAwaitClassFileGenerator.class);
    private static final Type COMPLETION_STAGE_TYPE = Type.getObjectType("java/util/concurrent/CompletionStage");
    private static final Type COMPLETABLE_FUTURE_TYPE = Type.getObjectType("java/util/concurrent/CompletableFuture");
    private static final Type ASYNC_RESULT_TYPE = Type.getObjectType("net/tascalate/async/AsyncResult");
    private static final Type TASCALATE_PROMISE_TYPE = Type.getObjectType("net/tascalate/concurrent/Promise");
    private static final Type ASYNC_GENERATOR_TYPE = Type.getObjectType("net/tascalate/async/AsyncGenerator");
    private static final Set<Type> ASYNC_TASK_RETURN_TYPES = Stream.of(COMPLETION_STAGE_TYPE, COMPLETABLE_FUTURE_TYPE, ASYNC_RESULT_TYPE, TASCALATE_PROMISE_TYPE, Type.VOID_TYPE).collect(Collectors.toSet());
    private final List<ClassNode> newClasses = new ArrayList<ClassNode>();
    private final Map<String, MethodNode> accessMethods = new HashMap<String, MethodNode>();
    private final Map<String, ClassNode> superclasses = new HashMap<String, ClassNode>();
    private final ClassHierarchy classHierarchy;
    private final boolean verify;
    private final boolean trace;

    public AsyncAwaitClassFileGenerator(ResourceLoader resourceLoader) {
        this(resourceLoader, true, false);
    }

    public AsyncAwaitClassFileGenerator(ResourceLoader resourceLoader, boolean verify, boolean trace) {
        this.classHierarchy = new ClassHierarchy(new AsmxResourceLoader(resourceLoader));
        this.verify = verify;
        this.trace = trace;
    }

    public byte[] transform(byte[] classfileBuffer) {
        ClassReader classReader = new ClassReader(classfileBuffer);
        ClassNode classNode = new ClassNode();
        classReader.accept(classNode, 4);
        if (!this.transform(classNode)) {
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug("Transformed class:\n\n" + BytecodeTraceUtil.toString(classNode) + "\n\n");
            for (ClassNode newClass : this.newClasses) {
                log.debug("Generated class:\n\n" + BytecodeTraceUtil.toString(newClass) + "\n\n");
            }
        }
        OfflineClassWriter cw = new OfflineClassWriter(this.classHierarchy, 2);
        classNode.accept(this.decorate(cw));
        byte[] generatedClassBytes = cw.toByteArray();
        return generatedClassBytes;
    }

    public Map<String, byte[]> getGeneratedClasses() {
        HashMap<String, byte[]> result = new HashMap<String, byte[]>();
        for (ClassNode classNode : this.newClasses) {
            OfflineClassWriter cw = new OfflineClassWriter(this.classHierarchy, 2);
            classNode.accept(this.decorate(cw));
            result.put(classNode.name, cw.toByteArray());
        }
        return result;
    }

    public void reset() {
        this.accessMethods.clear();
        this.newClasses.clear();
    }

    protected ClassVisitor decorate(ClassVisitor classVisitor) {
        ClassVisitor result = classVisitor;
        if (this.verify) {
            result = new CheckClassAdapter(result, true);
        }
        if (this.trace) {
            result = new TraceClassVisitor(result, new PrintWriter(System.out));
        }
        return result;
    }

    protected boolean transform(ClassNode classNode) {
        boolean transformed = false;
        AbstractAsyncMethodTransformer.Helper helper = new AbstractAsyncMethodTransformer.Helper(){

            @Override
            public ClassNode resolveClass(String cn) {
                return AsyncAwaitClassFileGenerator.this.superclasses.computeIfAbsent(cn, className -> {
                    try (InputStream in = AsyncAwaitClassFileGenerator.this.classHierarchy.loader().getResourceAsStream(className + ".class");){
                        ClassReader classReader = new ClassReader(in);
                        ClassNode classNode = new ClassNode();
                        classReader.accept(classNode, 4);
                        ClassNode classNode2 = classNode;
                        return classNode2;
                    }
                    catch (IOException ex) {
                        throw new RuntimeException(ex);
                    }
                });
            }

            @Override
            public boolean isSubClass(String maybeSubclass, String gmaybeParentClass) {
                return AsyncAwaitClassFileGenerator.this.classHierarchy.isSubClass(maybeSubclass, gmaybeParentClass);
            }
        };
        for (MethodNode methodNode : new ArrayList<MethodNode>(BytecodeIntrospection.methodsOf(classNode))) {
            ClassNode newClass;
            if (!BytecodeIntrospection.isAsyncMethod(methodNode)) continue;
            Type returnType = Type.getReturnType(methodNode.desc);
            AbstractAsyncMethodTransformer transformer = null;
            if (ASYNC_TASK_RETURN_TYPES.contains(returnType)) {
                transformer = new AsyncTaskMethodTransformer(classNode, methodNode, this.accessMethods, helper);
            } else if (ASYNC_GENERATOR_TYPE.equals(returnType)) {
                transformer = new AsyncGeneratorMethodTransformer(classNode, methodNode, this.accessMethods, helper);
            }
            if (null == transformer || null == (newClass = ((AbstractAsyncMethodTransformer)transformer).transform())) continue;
            this.newClasses.add(newClass);
            transformed = true;
        }
        return transformed;
    }
}

