/*
 * Decompiled with CFR 0.152.
 */
package net.tascalate.async.tools.core;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.tascalate.asmx.Handle;
import net.tascalate.asmx.MethodVisitor;
import net.tascalate.asmx.Type;
import net.tascalate.asmx.tree.AbstractInsnNode;
import net.tascalate.asmx.tree.AnnotationNode;
import net.tascalate.asmx.tree.ClassNode;
import net.tascalate.asmx.tree.FieldInsnNode;
import net.tascalate.asmx.tree.FieldNode;
import net.tascalate.asmx.tree.InnerClassNode;
import net.tascalate.asmx.tree.InvokeDynamicInsnNode;
import net.tascalate.asmx.tree.MethodInsnNode;
import net.tascalate.asmx.tree.MethodNode;
import net.tascalate.asmx.tree.TypeAnnotationNode;
import net.tascalate.async.tools.core.AsyncAwaitClassFileGenerator;
import net.tascalate.async.tools.core.BytecodeIntrospection;
import net.tascalate.async.tools.core.BytecodeTraceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAsyncMethodTransformer {
    protected static final Logger log = LoggerFactory.getLogger(AsyncAwaitClassFileGenerator.class);
    private static final String ASYNC_ANNOTATION_DESCRIPTOR = "Lnet/tascalate/async/async;";
    protected static final String CALL_CONTXT_NAME = "net/tascalate/async/CallContext";
    protected static final Type SUSPENDABLE_ANNOTATION_TYPE = Type.getObjectType("net/tascalate/async/suspendable");
    protected static final Type COMPLETION_STAGE_TYPE = Type.getObjectType("java/util/concurrent/CompletionStage");
    protected static final Type METHOD_HANDLES_TYPE = Type.getType(MethodHandles.class);
    protected static final Type METHOD_HANDLES_LOOKUP_TYPE = Type.getType(MethodHandles.Lookup.class);
    protected static final Type OBJECT_TYPE = Type.getType(Object.class);
    protected static final Type STRING_TYPE = Type.getType(String.class);
    protected static final Type CLASS_TYPE = Type.getType(Class.class);
    protected static final Type ASYNC_METHOD_EXECUTOR_TYPE = Type.getObjectType("net/tascalate/async/core/AsyncMethodExecutor");
    protected static final Type TASCALATE_PROMISE_TYPE = Type.getObjectType("net/tascalate/concurrent/Promise");
    protected static final Type TASCALATE_PROMISES_TYPE = Type.getObjectType("net/tascalate/concurrent/Promises");
    protected static final Type ABSTRACT_ASYNC_METHOD_TYPE = Type.getObjectType("net/tascalate/async/core/AbstractAsyncMethod");
    private static final Type SCHEDULER_TYPE = Type.getObjectType("net/tascalate/async/Scheduler");
    private static final Type SCHEDULER_PROVIDER_TYPE = Type.getObjectType("net/tascalate/async/SchedulerProvider");
    protected final ClassNode classNode;
    protected final MethodNode originalAsyncMethod;
    protected final Map<String, MethodNode> accessMethods;
    protected final Helper helper;

    protected AbstractAsyncMethodTransformer(ClassNode classNode, MethodNode originalAsyncMethod, Map<String, MethodNode> accessMethods, Helper helper) {
        this.classNode = classNode;
        this.originalAsyncMethod = originalAsyncMethod;
        this.accessMethods = accessMethods;
        this.helper = helper;
    }

    protected abstract ClassNode transform();

    protected ClassNode transform(Type superClassType) {
        if (log.isDebugEnabled()) {
            log.debug("Transforming blocking method: " + this.classNode.name + "." + this.originalAsyncMethod.name + this.originalAsyncMethod.desc);
        }
        String asyncTaskClassName = BytecodeIntrospection.createInnerClassName(this.classNode);
        BytecodeIntrospection.innerClassesOf(this.classNode).add(new InnerClassNode(asyncTaskClassName, null, null, this.originalAsyncMethod.access & 8));
        this.createAccessMethodsForAsyncMethod();
        ClassNode asyncTaskClassNode = this.createAnonymousClass(asyncTaskClassName, superClassType);
        List<MethodNode> methods = BytecodeIntrospection.methodsOf(this.classNode);
        methods.remove(this.originalAsyncMethod);
        this.createReplacementAsyncMethod(asyncTaskClassName);
        return asyncTaskClassNode;
    }

    protected abstract MethodVisitor createReplacementAsyncMethod(String var1);

    protected abstract MethodVisitor addAnonymousClassRunMethod(ClassNode var1, FieldNode var2);

    protected ClassNode createAnonymousClass(String asyncTaskClassName, Type superClassType) {
        boolean isStatic = (this.originalAsyncMethod.access & 8) != 0;
        ClassNode asyncRunnableClass = new ClassNode();
        asyncRunnableClass.visit(this.classNode.version, 48, asyncTaskClassName, null, superClassType.getInternalName(), null);
        asyncRunnableClass.visitSource(this.classNode.sourceFile, null);
        asyncRunnableClass.visitOuterClass(this.classNode.name, this.originalAsyncMethod.name, this.originalAsyncMethod.desc);
        asyncRunnableClass.visitField(26, "serialVersionUID", "J", null, 1L);
        FieldNode outerClassField = !isStatic ? (FieldNode)asyncRunnableClass.visitField(4114, "this$0", "L" + this.classNode.name + ";", null, null) : null;
        Type[] argTypes = Type.getArgumentTypes(this.originalAsyncMethod.desc);
        int originalArity = argTypes.length;
        for (int i = 0; i < originalArity; ++i) {
            String argName = BytecodeIntrospection.createOuterClassMethodArgFieldName(i);
            String argDesc = argTypes[i].getDescriptor();
            asyncRunnableClass.visitField(4098, argName, argDesc, null, null);
        }
        this.addAnonymousClassConstructor(asyncRunnableClass, superClassType, outerClassField);
        this.addAnonymousClassRunMethod(asyncRunnableClass, outerClassField);
        this.addAnonymousClassToStringMethod(asyncRunnableClass, superClassType);
        return asyncRunnableClass;
    }

    protected MethodVisitor addAnonymousClassConstructor(ClassNode asyncRunnableClass, Type superClassType, FieldNode outerClassField) {
        boolean isStatic = (this.originalAsyncMethod.access & 8) != 0;
        Type[] originalArgTypes = Type.getArgumentTypes(this.originalAsyncMethod.desc);
        int originalArity = originalArgTypes.length;
        String constructorDesc = Type.getMethodDescriptor(Type.VOID_TYPE, AbstractAsyncMethodTransformer.appendArray(isStatic ? originalArgTypes : AbstractAsyncMethodTransformer.prependArray(originalArgTypes, Type.getObjectType(this.classNode.name)), SCHEDULER_TYPE));
        MethodVisitor result = asyncRunnableClass.visitMethod(0, "<init>", constructorDesc, null, null);
        result.visitCode();
        if (!isStatic) {
            result.visitVarInsn(25, 0);
            result.visitVarInsn(25, 1);
            result.visitFieldInsn(181, asyncRunnableClass.name, outerClassField.name, outerClassField.desc);
        }
        int paramVarIdx = isStatic ? 1 : 2;
        boolean hasDWordParam = false;
        for (int i = 0; i < originalArity; ++i) {
            Type argType = originalArgTypes[i];
            result.visitVarInsn(25, 0);
            result.visitVarInsn(argType.getOpcode(21), paramVarIdx);
            paramVarIdx += argType.getSize();
            hasDWordParam |= argType.getSize() > 1;
            result.visitFieldInsn(181, asyncRunnableClass.name, BytecodeIntrospection.createOuterClassMethodArgFieldName(i), argType.getDescriptor());
        }
        result.visitVarInsn(25, 0);
        result.visitVarInsn(25, paramVarIdx);
        result.visitMethodInsn(183, superClassType.getInternalName(), "<init>", Type.getMethodDescriptor(Type.VOID_TYPE, SCHEDULER_TYPE), false);
        result.visitInsn(177);
        result.visitMaxs(hasDWordParam ? 3 : 2, paramVarIdx + 1);
        result.visitEnd();
        return result;
    }

    protected MethodVisitor addAnonymousClassToStringMethod(ClassNode asyncRunnableClass, Type runnableBaseClass) {
        MethodVisitor result = asyncRunnableClass.visitMethod(1, "toString", Type.getMethodDescriptor(STRING_TYPE, new Type[0]), null, null);
        result.visitVarInsn(25, 0);
        result.visitLdcInsn(this.classNode.name.replace('/', '.'));
        result.visitLdcInsn(BytecodeIntrospection.getMethodSignature(this.originalAsyncMethod, true));
        result.visitMethodInsn(182, runnableBaseClass.getInternalName(), "toString", Type.getMethodDescriptor(STRING_TYPE, STRING_TYPE, STRING_TYPE), false);
        result.visitInsn(176);
        result.visitMaxs(3, 1);
        return result;
    }

    protected Object[] findOwnerInvokeDynamic(AbstractInsnNode instruction, List<MethodNode> ownerMethods) {
        if (instruction instanceof InvokeDynamicInsnNode) {
            InvokeDynamicInsnNode n = (InvokeDynamicInsnNode)instruction;
            Handle bsm = n.bsm;
            if ("java/lang/invoke/LambdaMetafactory".equals(bsm.getOwner()) && "metafactory".equals(bsm.getName())) {
                MethodNode targetMethodNode;
                Handle method = Arrays.stream(n.bsmArgs).filter(Handle.class::isInstance).map(Handle.class::cast).filter(h -> h.getOwner().equals(this.classNode.name)).findFirst().orElse(null);
                if (null != method && null != (targetMethodNode = BytecodeIntrospection.getMethod(method.getName(), method.getDesc(), ownerMethods)) && (targetMethodNode.access & 0x1000) == 4096) {
                    return new Object[]{method, targetMethodNode};
                }
            }
        }
        return null;
    }

    protected MethodVisitor createReplacementAsyncMethod(String asyncTaskClassName, Type runnableBaseClass, String runnableFieldName, Type runnableFieldType) {
        boolean hasResult;
        boolean isStatic = (this.originalAsyncMethod.access & 8) != 0;
        int thisArgShift = isStatic ? 0 : 1;
        Type[] originalArgTypes = Type.getArgumentTypes(this.originalAsyncMethod.desc);
        int originalArity = originalArgTypes.length;
        MethodVisitor result = this.classNode.visitMethod(this.originalAsyncMethod.access, this.originalAsyncMethod.name, this.originalAsyncMethod.desc, this.originalAsyncMethod.signature, null);
        BytecodeIntrospection.invisibleAnnotationsOf(this.originalAsyncMethod).stream().filter(an -> !ASYNC_ANNOTATION_DESCRIPTOR.equals(an.desc)).forEach(an -> an.accept(result.visitAnnotation(an.desc, false)));
        BytecodeIntrospection.visibleAnnotationsOf(this.originalAsyncMethod).forEach(an -> an.accept(result.visitAnnotation(an.desc, true)));
        BytecodeIntrospection.invisibleTypeAnnotationsOf(this.originalAsyncMethod).forEach(an -> an.accept(result.visitTypeAnnotation(an.typeRef, an.typePath, an.desc, false)));
        BytecodeIntrospection.visibleTypeAnnotationsOf(this.originalAsyncMethod).forEach(an -> an.accept(result.visitTypeAnnotation(an.typeRef, an.typePath, an.desc, true)));
        result.visitAnnotation(SUSPENDABLE_ANNOTATION_TYPE.getDescriptor(), true).visitEnd();
        this.copyParameterAnnotations(result, BytecodeIntrospection.invisibleParameterAnnotationsOf(this.originalAsyncMethod), false);
        this.copyParameterAnnotations(result, BytecodeIntrospection.visibleParameterAnnotationsOf(this.originalAsyncMethod), true);
        result.visitCode();
        int providedSchedulerParamIdx = this.schedulerProviderParamIdx(this.originalAsyncMethod);
        if (providedSchedulerParamIdx >= 0) {
            result.visitVarInsn(25, providedSchedulerParamIdx + thisArgShift);
        } else {
            result.visitInsn(1);
        }
        if (isStatic) {
            result.visitInsn(1);
        } else {
            result.visitVarInsn(25, 0);
        }
        result.visitMethodInsn(184, METHOD_HANDLES_TYPE.getInternalName(), "lookup", Type.getMethodDescriptor(METHOD_HANDLES_LOOKUP_TYPE, new Type[0]), false);
        result.visitMethodInsn(184, ASYNC_METHOD_EXECUTOR_TYPE.getInternalName(), "currentScheduler", Type.getMethodDescriptor(SCHEDULER_TYPE, SCHEDULER_TYPE, OBJECT_TYPE, METHOD_HANDLES_LOOKUP_TYPE), false);
        String constructorDesc = Type.getMethodDescriptor(Type.VOID_TYPE, AbstractAsyncMethodTransformer.appendArray(isStatic ? originalArgTypes : AbstractAsyncMethodTransformer.prependArray(originalArgTypes, Type.getObjectType(this.classNode.name)), SCHEDULER_TYPE));
        int schedulerVarIdx = Arrays.stream(originalArgTypes).mapToInt(a -> a.getSize()).sum() + thisArgShift;
        result.visitVarInsn(58, schedulerVarIdx);
        result.visitTypeInsn(187, asyncTaskClassName);
        result.visitInsn(89);
        if (!isStatic) {
            result.visitVarInsn(25, 0);
        }
        int paramVarIdx = thisArgShift;
        for (int i = 0; i < originalArity; ++i) {
            Type originalArgType = originalArgTypes[i];
            result.visitVarInsn(originalArgType.getOpcode(21), paramVarIdx);
            paramVarIdx += originalArgType.getSize();
        }
        result.visitVarInsn(25, schedulerVarIdx);
        result.visitMethodInsn(183, asyncTaskClassName, "<init>", constructorDesc, false);
        int methodVarIdx = schedulerVarIdx + 1;
        result.visitVarInsn(58, methodVarIdx);
        result.visitVarInsn(25, methodVarIdx);
        result.visitMethodInsn(184, ASYNC_METHOD_EXECUTOR_TYPE.getInternalName(), "execute", Type.getMethodDescriptor(Type.VOID_TYPE, ABSTRACT_ASYNC_METHOD_TYPE), false);
        Type returnType = Type.getReturnType(this.originalAsyncMethod.desc);
        boolean bl = hasResult = !Type.VOID_TYPE.equals(returnType);
        if (hasResult) {
            result.visitVarInsn(25, methodVarIdx);
            result.visitFieldInsn(180, runnableBaseClass.getInternalName(), runnableFieldName, runnableFieldType.getDescriptor());
            if (TASCALATE_PROMISE_TYPE.equals(returnType)) {
                result.visitMethodInsn(184, TASCALATE_PROMISES_TYPE.getInternalName(), "from", Type.getMethodDescriptor(TASCALATE_PROMISE_TYPE, COMPLETION_STAGE_TYPE), false);
            }
            result.visitInsn(176);
        } else {
            result.visitInsn(177);
        }
        result.visitMaxs(Math.max(4, methodVarIdx + 2), methodVarIdx + 1);
        result.visitEnd();
        return result;
    }

    protected void copyParameterAnnotations(MethodVisitor target, List<AnnotationNode>[] annotationsByIdx, boolean visible) {
        if (null == annotationsByIdx) {
            return;
        }
        for (int i = 0; i < annotationsByIdx.length; ++i) {
            List<AnnotationNode> annotations = annotationsByIdx[i];
            if (null == annotations) continue;
            int idx = 0;
            annotations.forEach(an -> an.accept(target.visitParameterAnnotation(idx, an.desc, visible)));
        }
    }

    protected int schedulerProviderParamIdx(MethodNode methodNode) {
        int result = -1;
        List<AnnotationNode>[] annotationBatches = BytecodeIntrospection.visibleParameterAnnotationsOf(methodNode);
        if (null == annotationBatches) {
            return -1;
        }
        int idx = 0;
        for (List<AnnotationNode> annotations : annotationBatches) {
            boolean found;
            if (null != annotations && (found = annotations.stream().anyMatch(a -> SCHEDULER_PROVIDER_TYPE.getDescriptor().equals(a.desc)))) {
                if (result < 0) {
                    result = idx;
                } else {
                    throw new IllegalStateException("More than one parameter of " + methodNode.desc + " is annotated as @SchedulerProvider");
                }
            }
            ++idx;
        }
        return result;
    }

    protected static List<TypeAnnotationNode> copyTypeAnnotations(List<TypeAnnotationNode> originalAnnotations) {
        if (null == originalAnnotations || originalAnnotations.isEmpty()) {
            return null;
        }
        return originalAnnotations.stream().map(t -> new TypeAnnotationNode(t.typeRef, t.typePath, t.desc)).collect(Collectors.toCollection(ArrayList::new));
    }

    protected void createAccessMethodsForAsyncMethod() {
        List<MethodNode> methods = BytecodeIntrospection.methodsOf(this.classNode);
        for (AbstractInsnNode instruction : this.originalAsyncMethod.instructions) {
            Object[] result;
            boolean samePackageAccessible;
            String actualClassName;
            if (instruction instanceof MethodInsnNode) {
                MethodInsnNode methodInstructionNode = (MethodInsnNode)instruction;
                boolean isOwnMethod = methodInstructionNode.owner.equals(this.classNode.name);
                if ((methodInstructionNode.getOpcode() == 182 || methodInstructionNode.getOpcode() == 183 || methodInstructionNode.getOpcode() == 184) && (isOwnMethod || this.helper.isSubClass(this.classNode.name, methodInstructionNode.owner))) {
                    MethodNode targetMethodNode;
                    MethodNode methodNode = targetMethodNode = isOwnMethod ? BytecodeIntrospection.getMethod(methodInstructionNode.name, methodInstructionNode.desc, methods) : null;
                    if (null == targetMethodNode) {
                        targetMethodNode = this.findClassMethod(this.classNode.superName, methodInstructionNode);
                        actualClassName = targetMethodNode != null ? targetMethodNode.signature : null;
                        isOwnMethod = false;
                    } else {
                        actualClassName = this.classNode.name;
                    }
                    boolean bl = samePackageAccessible = !(methodInstructionNode.getOpcode() != 182 && methodInstructionNode.getOpcode() != 184 || null == targetMethodNode || (targetMethodNode.access & 2) != 0 || (targetMethodNode.access & 1) == 0 && !AbstractAsyncMethodTransformer.samePackage(this.classNode.name, actualClassName));
                    if (!samePackageAccessible) {
                        if (log.isTraceEnabled()) {
                            log.trace("Found private call " + BytecodeTraceUtil.toString(methodInstructionNode));
                        }
                        this.createAccessMethod(methodInstructionNode, methods);
                    }
                }
            }
            if (instruction instanceof FieldInsnNode) {
                FieldInsnNode fieldInstructionNode = (FieldInsnNode)instruction;
                boolean isOwnField = fieldInstructionNode.owner.equals(this.classNode.name);
                if (isOwnField || this.helper.isSubClass(this.classNode.name, fieldInstructionNode.owner)) {
                    FieldNode targetFieldNode;
                    FieldNode fieldNode = targetFieldNode = isOwnField ? BytecodeIntrospection.getField(this.classNode, fieldInstructionNode.name, fieldInstructionNode.desc) : null;
                    if (null == targetFieldNode) {
                        targetFieldNode = this.findClassField(this.classNode.superName, fieldInstructionNode);
                        actualClassName = null != targetFieldNode ? targetFieldNode.signature : null;
                        isOwnField = false;
                    } else {
                        actualClassName = this.classNode.name;
                    }
                    boolean bl = samePackageAccessible = null != targetFieldNode && (targetFieldNode.access & 2) == 0 && ((targetFieldNode.access & 1) != 0 || AbstractAsyncMethodTransformer.samePackage(this.classNode.name, actualClassName));
                    if (!samePackageAccessible) {
                        if (log.isTraceEnabled()) {
                            log.trace("Found private field access " + BytecodeTraceUtil.toString(fieldInstructionNode));
                        }
                        if (fieldInstructionNode.getOpcode() == 178 || fieldInstructionNode.getOpcode() == 180) {
                            this.createAccessGetter(fieldInstructionNode, methods);
                        } else if (fieldInstructionNode.getOpcode() == 179 || fieldInstructionNode.getOpcode() == 181) {
                            this.createAccessSetter(fieldInstructionNode, methods);
                        }
                    }
                }
            }
            if (!(instruction instanceof InvokeDynamicInsnNode) || null == (result = this.findOwnerInvokeDynamic(instruction, methods))) continue;
            this.createAccessLambda((InvokeDynamicInsnNode)instruction, (Handle)result[0], true, methods);
        }
    }

    protected MethodNode createAccessLambda(InvokeDynamicInsnNode dynNode, Handle h, boolean isStatic, List<MethodNode> methods) {
        Type[] originalArgTypes;
        MethodNode accessMethodNode = this.getAccessMethod(h.getOwner(), h.getName(), h.getDesc(), "L");
        if (null != accessMethodNode) {
            return accessMethodNode;
        }
        String name = BytecodeIntrospection.createAccessMethodName(methods);
        Type[] argTypes = originalArgTypes = Type.getArgumentTypes(dynNode.desc);
        Type returnType = Type.getReturnType(dynNode.desc);
        String desc = Type.getMethodDescriptor(returnType, argTypes);
        int publicFlag = (this.classNode.access & 0x200) != 0 ? 1 : 0;
        accessMethodNode = new MethodNode(4104 + publicFlag, name, desc, null, null);
        accessMethodNode.visitAnnotation(SUSPENDABLE_ANNOTATION_TYPE.getDescriptor(), true).visitEnd();
        accessMethodNode.visitCode();
        int paramVarIdx = 0;
        for (Type argType : argTypes) {
            int opcode = argType.getOpcode(21);
            if (log.isTraceEnabled()) {
                log.trace("Using opcode " + opcode + " for loading " + argType);
            }
            accessMethodNode.visitVarInsn(opcode, paramVarIdx);
            paramVarIdx += argType.getSize();
        }
        accessMethodNode.visitInvokeDynamicInsn(dynNode.name, dynNode.desc, dynNode.bsm, dynNode.bsmArgs);
        accessMethodNode.visitInsn(returnType.getOpcode(172));
        accessMethodNode.visitMaxs(Math.max(paramVarIdx, returnType.getSize()), paramVarIdx);
        accessMethodNode.visitEnd();
        this.registerAccessMethod(h.getOwner(), h.getName(), h.getDesc(), "L", accessMethodNode);
        methods.add(accessMethodNode);
        return accessMethodNode;
    }

    protected MethodNode createAccessMethod(MethodInsnNode targetMethodNode, List<MethodNode> methods) {
        MethodNode accessMethodNode = this.getAccessMethod(targetMethodNode.owner, targetMethodNode.name, targetMethodNode.desc, "M");
        if (null != accessMethodNode) {
            return accessMethodNode;
        }
        String name = BytecodeIntrospection.createAccessMethodName(methods);
        Type[] originalArgTypes = Type.getArgumentTypes(targetMethodNode.desc);
        Type[] argTypes = targetMethodNode.getOpcode() == 184 ? originalArgTypes : AbstractAsyncMethodTransformer.prependArray(originalArgTypes, Type.getObjectType(this.classNode.name));
        Type returnType = Type.getReturnType(targetMethodNode.desc);
        String desc = Type.getMethodDescriptor(returnType, argTypes);
        int publicFlag = (this.classNode.access & 0x200) != 0 ? 1 : 0;
        accessMethodNode = new MethodNode(4104 + publicFlag, name, desc, null, null);
        accessMethodNode.visitAnnotation(SUSPENDABLE_ANNOTATION_TYPE.getDescriptor(), true).visitEnd();
        accessMethodNode.visitCode();
        int paramVarIdx = 0;
        for (Type argType : argTypes) {
            int opcode = argType.getOpcode(21);
            if (log.isTraceEnabled()) {
                log.trace("Using opcode " + opcode + " for loading " + argType);
            }
            accessMethodNode.visitVarInsn(opcode, paramVarIdx);
            paramVarIdx += argType.getSize();
        }
        accessMethodNode.visitMethodInsn(targetMethodNode.getOpcode(), targetMethodNode.owner, targetMethodNode.name, targetMethodNode.desc, targetMethodNode.itf);
        accessMethodNode.visitInsn(returnType.getOpcode(172));
        accessMethodNode.visitMaxs(Math.max(paramVarIdx, returnType.getSize()), paramVarIdx);
        accessMethodNode.visitEnd();
        this.registerAccessMethod(targetMethodNode.owner, targetMethodNode.name, targetMethodNode.desc, "M", accessMethodNode);
        methods.add(accessMethodNode);
        return accessMethodNode;
    }

    protected MethodNode createAccessGetter(FieldInsnNode targetFieldNode, List<MethodNode> methods) {
        MethodNode accessMethodNode = this.getAccessMethod(targetFieldNode.owner, targetFieldNode.name, targetFieldNode.desc, "G");
        if (null != accessMethodNode) {
            return accessMethodNode;
        }
        String name = BytecodeIntrospection.createAccessMethodName(methods);
        Type returnType = Type.getType(targetFieldNode.desc);
        if (targetFieldNode.getOpcode() == 178) {
            String desc = Type.getMethodDescriptor(returnType, new Type[0]);
            accessMethodNode = new MethodNode(4104, name, desc, null, null);
            accessMethodNode.visitCode();
            accessMethodNode.visitFieldInsn(178, targetFieldNode.owner, targetFieldNode.name, targetFieldNode.desc);
            accessMethodNode.visitInsn(returnType.getOpcode(172));
            accessMethodNode.visitMaxs(1, 0);
        } else {
            if (targetFieldNode.getOpcode() != 180) {
                throw new IllegalArgumentException("Unexpected opcode, should be either GETSTATIC / GETFILED: " + targetFieldNode.getOpcode());
            }
            Type objectType = Type.getObjectType(this.classNode.name);
            String desc = Type.getMethodDescriptor(returnType, objectType);
            accessMethodNode = new MethodNode(4104, name, desc, null, null);
            accessMethodNode.visitCode();
            accessMethodNode.visitVarInsn(objectType.getOpcode(21), 0);
            accessMethodNode.visitFieldInsn(180, targetFieldNode.owner, targetFieldNode.name, targetFieldNode.desc);
            accessMethodNode.visitInsn(returnType.getOpcode(172));
            accessMethodNode.visitMaxs(1, 1);
        }
        accessMethodNode.visitEnd();
        this.registerAccessMethod(targetFieldNode.owner, targetFieldNode.name, targetFieldNode.desc, "G", accessMethodNode);
        methods.add(accessMethodNode);
        return accessMethodNode;
    }

    protected MethodNode createAccessSetter(FieldInsnNode targetFieldNode, List<MethodNode> methods) {
        MethodNode accessMethodNode = this.getAccessMethod(targetFieldNode.owner, targetFieldNode.name, targetFieldNode.desc, "S");
        if (null != accessMethodNode) {
            return accessMethodNode;
        }
        String name = BytecodeIntrospection.createAccessMethodName(methods);
        Type fieldType = Type.getType(targetFieldNode.desc);
        if (targetFieldNode.getOpcode() == 179) {
            String desc = Type.getMethodDescriptor(Type.VOID_TYPE, fieldType);
            accessMethodNode = new MethodNode(4104, name, desc, null, null);
            accessMethodNode.visitCode();
            accessMethodNode.visitVarInsn(fieldType.getOpcode(21), 0);
            accessMethodNode.visitFieldInsn(179, targetFieldNode.owner, targetFieldNode.name, targetFieldNode.desc);
            accessMethodNode.visitInsn(177);
            accessMethodNode.visitMaxs(1, 1);
        } else {
            if (targetFieldNode.getOpcode() != 181) {
                throw new IllegalArgumentException("Unexpected opcode, should be either PUTSTATIC / PUTFILED: " + targetFieldNode.getOpcode());
            }
            Type objectType = Type.getObjectType(this.classNode.name);
            String desc = Type.getMethodDescriptor(Type.VOID_TYPE, objectType, fieldType);
            accessMethodNode = new MethodNode(4104, name, desc, null, null);
            accessMethodNode.visitCode();
            accessMethodNode.visitVarInsn(objectType.getOpcode(21), 0);
            accessMethodNode.visitVarInsn(fieldType.getOpcode(21), 1);
            accessMethodNode.visitFieldInsn(181, targetFieldNode.owner, targetFieldNode.name, targetFieldNode.desc);
            accessMethodNode.visitInsn(177);
            accessMethodNode.visitMaxs(1 + fieldType.getSize(), 1 + fieldType.getSize());
        }
        accessMethodNode.visitEnd();
        this.registerAccessMethod(targetFieldNode.owner, targetFieldNode.name, targetFieldNode.desc, "S", accessMethodNode);
        methods.add(accessMethodNode);
        return accessMethodNode;
    }

    private void registerAccessMethod(String owner, String name, String desc, String kind, MethodNode methodNode) {
        this.accessMethods.put(owner + name + desc + "-" + kind, methodNode);
    }

    protected MethodNode getAccessMethod(String owner, String name, String desc, String kind) {
        return this.accessMethods.get(owner + name + desc + "-" + kind);
    }

    protected MethodNode findClassMethod(String className, MethodInsnNode methodInstructionNode) {
        ClassNode classNode = this.helper.resolveClass(className);
        MethodNode result = BytecodeIntrospection.getMethod(methodInstructionNode.name, methodInstructionNode.desc, BytecodeIntrospection.methodsOf(classNode));
        if (null != result) {
            result.signature = classNode.name;
            return result;
        }
        if (null == classNode.superName) {
            return null;
        }
        return this.findClassMethod(classNode.superName, methodInstructionNode);
    }

    protected FieldNode findClassField(String className, FieldInsnNode fieldInstructionNode) {
        ClassNode classNode = this.helper.resolveClass(className);
        FieldNode result = BytecodeIntrospection.getField(classNode, fieldInstructionNode.name, fieldInstructionNode.desc);
        if (null != result) {
            result.signature = classNode.name;
            return result;
        }
        if (null == classNode.superName) {
            return null;
        }
        return this.findClassField(classNode.superName, fieldInstructionNode);
    }

    protected static boolean samePackage(String classA, String classB) {
        return Objects.equals(AbstractAsyncMethodTransformer.packageNameOf(classA), AbstractAsyncMethodTransformer.packageNameOf(classB));
    }

    private static String packageNameOf(String clazz) {
        int ind = null == clazz ? -1 : clazz.lastIndexOf(47);
        return ind > 0 ? clazz.substring(0, ind) : "";
    }

    protected static int findOriginalArgumentIndex(Type[] arguments, int var, boolean isStaticMethod) {
        int varParamIdx = isStaticMethod ? 0 : 1;
        int arity = arguments.length;
        for (int i = 0; i < arity && varParamIdx <= var; varParamIdx += arguments[i].getSize(), ++i) {
            if (varParamIdx != var) continue;
            return i;
        }
        return -1;
    }

    protected static Type[] prependArray(Type[] array, Type value) {
        Type[] result = new Type[array.length + 1];
        result[0] = value;
        System.arraycopy(array, 0, result, 1, array.length);
        return result;
    }

    protected static Type[] appendArray(Type[] array, Type value) {
        Type[] result = new Type[array.length + 1];
        System.arraycopy(array, 0, result, 0, array.length);
        result[result.length - 1] = value;
        return result;
    }

    static interface Helper {
        public boolean isSubClass(String var1, String var2);

        public ClassNode resolveClass(String var1);
    }
}

