/**
 * ﻿Copyright 2015-2022 Valery Silaev (http://vsilaev.com)
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:

 * * Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.

 * * Redistributions in binary form must reproduce the above copyright notice,
 *   this list of conditions and the following disclaimer in the documentation
 *   and/or other materials provided with the distribution.

 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package net.tascalate.async.resolver.provided;

import java.lang.invoke.MethodHandles;

import org.kohsuke.MetaInfServices;

import net.tascalate.async.Scheduler;
import net.tascalate.async.spi.SchedulerProviderLookup;
import net.tascalate.async.spi.SchedulerResolver;

@MetaInfServices
public class GetSchedulerFromProvider implements SchedulerResolver {
    
    private final SchedulerProviderLookup lookup = new SchedulerProviderLookup(true, true, true, false);

    @Override
    public int priority() {
        return 500;
    }

    @Override
    public Scheduler resolve(Object owner, MethodHandles.Lookup ownerClassLookup) {
        if (null == owner) {
            if (null == ownerClassLookup) {
                return null;
            }
            SchedulerProviderLookup.ClassAccessor cAccessor = lookup.getClassAccessor(ownerClassLookup);
            return null != cAccessor ? cAccessor.read() : null;
        } else {
            SchedulerProviderLookup.InstanceAccessor iAccessor = lookup.getInstanceAccessor(ownerClassLookup);
            if (null == iAccessor) {
                // If no instance accessor then try class accessor
                SchedulerProviderLookup.ClassAccessor cAccessor = lookup.getClassAccessor(ownerClassLookup);
                return null != cAccessor ? cAccessor.read() : null;
            } else {
                return iAccessor.read(owner);
            }
        }
    }
    
    @Override
    public String toString() {
        return String.format("%s[priority=%d, lookup=%s]", getClass().getSimpleName(), priority(), lookup);
    }
}
