/*
 * Decompiled with CFR 0.152.
 */
package net.tascalate.async.agent;

import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.security.ProtectionDomain;
import java.util.HashMap;
import java.util.Map;
import net.tascalate.async.tools.core.AsyncAwaitClassFileGenerator;
import net.tascalate.instrument.emitter.spi.ClassEmitter;
import net.tascalate.instrument.emitter.spi.PortableClassFileTransformer;
import org.apache.commons.javaflow.spi.ClasspathResourceLoader;
import org.apache.commons.javaflow.spi.ExtendedClasspathResourceLoader;
import org.apache.commons.javaflow.spi.InstrumentationUtils;
import org.apache.commons.javaflow.spi.ResourceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncClassBytecodeTransformer
extends PortableClassFileTransformer {
    private static final Logger log = LoggerFactory.getLogger(AsyncClassBytecodeTransformer.class);
    private final ClassLoader systemClassLoader = ClassLoader.getSystemClassLoader();
    private final ClassFileTransformer postProcessor;

    protected AsyncClassBytecodeTransformer(ClassFileTransformer postProcessor, Instrumentation instrumentation) {
        super(instrumentation);
        this.postProcessor = postProcessor;
    }

    protected byte[] transform(PortableClassFileTransformer.ClassEmitterFactory emitterFactory, Object module, ClassLoader originalClassLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        byte[] finalResult;
        Map extraClasses;
        if (this.isSystemClassLoaderParent(originalClassLoader)) {
            if (log.isDebugEnabled()) {
                log.debug("Ignoring class defined by boot or extensions/platform class loader: " + className);
            }
            return null;
        }
        ClassLoader classLoader = AsyncClassBytecodeTransformer.getSafeClassLoader(originalClassLoader);
        AsyncAwaitClassFileGenerator generator = new AsyncAwaitClassFileGenerator((ResourceLoader)new ClasspathResourceLoader(classLoader));
        try {
            byte[] transformed = generator.transform(classfileBuffer);
            if (null == transformed) {
                return this.postProcess(module, classLoader, className, classBeingRedefined, protectionDomain, classfileBuffer);
            }
            extraClasses = generator.getGeneratedClasses();
            generator.reset();
            finalResult = this.postProcess(module, classLoader, className, classBeingRedefined, protectionDomain, transformed);
        }
        catch (Error | RuntimeException | IllegalClassFormatException ex) {
            log.error("Error transforming class " + className, ex);
            throw ex;
        }
        if (!extraClasses.isEmpty()) {
            Map<String, byte[]> inMemoryResources = AsyncClassBytecodeTransformer.renameInMemoryResources(extraClasses);
            inMemoryResources.put(className + ".class", finalResult);
            ExtendedClasspathResourceLoader.runWithInMemoryResources(() -> this.defineGeneratedClasses(emitterFactory, module, classLoader, protectionDomain, extraClasses), inMemoryResources);
        }
        return finalResult;
    }

    protected byte[] postProcess(Object module, ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        if (null == classfileBuffer) {
            return null;
        }
        return AsyncClassBytecodeTransformer.callTransformer((ClassFileTransformer)this.postProcessor, (Object)module, (ClassLoader)classLoader, (String)className, classBeingRedefined, (ProtectionDomain)protectionDomain, (byte[])classfileBuffer);
    }

    protected void defineGeneratedClasses(PortableClassFileTransformer.ClassEmitterFactory emitterFactory, Object module, ClassLoader classLoader, ProtectionDomain protectionDomain, Map<String, byte[]> generatedClasses) {
        ClassEmitter emitter;
        if (generatedClasses.isEmpty()) {
            return;
        }
        try {
            emitter = emitterFactory.create(true);
        }
        catch (Error | RuntimeException ex) {
            log.error("Unable to create class bytecode emitter", ex);
            throw ex;
        }
        PortableClassFileTransformer.ClassEmitterFactory nestedEmitterFactory = __ -> emitter;
        for (Map.Entry<String, byte[]> e : generatedClasses.entrySet()) {
            byte[] bytes;
            String newClassName = e.getKey();
            try {
                if (log.isDebugEnabled()) {
                    log.debug("TRANSOFRMING: " + newClassName);
                }
                bytes = this.transform(nestedEmitterFactory, module, classLoader, e.getKey(), null, protectionDomain, e.getValue());
                e.setValue(bytes);
                if (log.isDebugEnabled()) {
                    log.debug("TRANSOFRMED: " + newClassName);
                }
            }
            catch (IllegalClassFormatException ex) {
                log.error("Unable to generate class bytecode for " + newClassName, (Throwable)ex);
                throw new RuntimeException(ex);
            }
            catch (Error | RuntimeException ex) {
                log.error("Unable to generate class bytecode for " + newClassName, ex);
                throw ex;
            }
            if (bytes == null) continue;
            try {
                if (log.isDebugEnabled()) {
                    log.debug("DEFINING: " + newClassName);
                }
                Class ignore = emitter.defineClass(bytes, protectionDomain);
                if (!log.isDebugEnabled()) continue;
                log.debug("DEFINED: " + newClassName);
            }
            catch (Throwable ex) {
                log.error("Unable to define generated class for " + newClassName, ex);
                throw new RuntimeException(ex);
            }
        }
    }

    private boolean isSystemClassLoaderParent(ClassLoader maybeParent) {
        return InstrumentationUtils.isClassLoaderParent((ClassLoader)this.systemClassLoader, (ClassLoader)maybeParent);
    }

    private static ClassLoader getSafeClassLoader(ClassLoader classLoader) {
        return null != classLoader ? classLoader : ClassLoader.getSystemClassLoader();
    }

    private static Map<String, byte[]> renameInMemoryResources(Map<String, byte[]> generatedClasses) {
        HashMap<String, byte[]> resources = new HashMap<String, byte[]>();
        for (Map.Entry<String, byte[]> e : generatedClasses.entrySet()) {
            resources.put(e.getKey() + ".class", e.getValue());
        }
        return resources;
    }
}

