/*
 * Decompiled with CFR 0.152.
 */
package net.tangly.spec.bdd.engine;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.tangly.spec.bdd.Feature;
import net.tangly.spec.bdd.Scene;
import net.tangly.spec.bdd.Story;
import org.jetbrains.annotations.NotNull;

public class StoryRun {
    private final Class<?> clazz;
    private final List<Scene> scenes;

    public StoryRun(@NotNull Class<?> clazz) {
        this.clazz = clazz;
        this.scenes = new ArrayList<Scene>();
    }

    public String name() {
        return this.clazz.getAnnotation(Story.class).value();
    }

    public String id() {
        return this.clazz.getAnnotation(Story.class).id();
    }

    public String description() {
        return this.clazz.getAnnotation(Story.class).description();
    }

    public List<String> storyTags() {
        return Arrays.asList(this.clazz.getAnnotation(Story.class).tags());
    }

    public Class<?> clazz() {
        return this.clazz;
    }

    public String featureName() {
        return this.clazz.getPackage().getAnnotation(Feature.class).value();
    }

    public String featureId() {
        return this.clazz.getPackage().getAnnotation(Feature.class).id();
    }

    public String featureDescription() {
        return this.clazz.getPackage().getAnnotation(Feature.class).description();
    }

    public List<String> featureTags() {
        return Arrays.asList(this.clazz.getPackage().getAnnotation(Feature.class).tags());
    }

    public Package packages() {
        return this.clazz.getPackage();
    }

    public void addScene(Scene scene) {
        this.scenes.add(scene);
    }

    public List<Scene> scenes() {
        return Collections.unmodifiableList(this.scenes);
    }

    public Scene findSceneByMethodName(String name) {
        return this.scenes.stream().filter(o -> name.equals(o.methodName())).findAny().orElse(null);
    }
}

