/*
 * Decompiled with CFR 0.152.
 */
package net.tangly.spec.bdd.engine;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONTokener;

public class StoryAsciiDocPublisher {
    private final PrintWriter writer;

    public StoryAsciiDocPublisher(@NotNull Path bddReport, @NotNull Path report) throws IOException {
        try (BufferedReader reader = Files.newBufferedReader(bddReport, StandardCharsets.UTF_8);){
            JSONArray features = new JSONArray(new JSONTokener((Reader)reader));
            this.writer = new PrintWriter(report.toFile(), StandardCharsets.UTF_8);
            this.documentHeader();
            features.forEach(item -> this.publishFeature((JSONObject)item));
            this.writer.flush();
            this.writer.close();
        }
    }

    private void documentHeader() {
        this.writer.println("---");
        this.writer.println("title: \"bdd Report\"");
        this.writer.println("date: 2020-01-01");
        this.writer.println("weight: 60");
        this.writer.println("draft: false");
        this.writer.println("---");
        this.writer.println();
    }

    private void publishFeature(@NotNull JSONObject feature) {
        this.header("Feature: " + feature.getString("name"), 2);
        this.paragraph(feature.getString("description"));
        this.publishTags(feature);
        feature.getJSONArray("stories").forEach(item -> this.publishStory((JSONObject)item));
    }

    private void publishStory(@NotNull JSONObject story) {
        this.header("Story: " + story.getString("name"), 3);
        this.paragraph(story.getString("description"));
        this.publishTags(story);
        story.getJSONArray("scenarios").forEach(item -> this.publishScenario((JSONObject)item));
    }

    private void publishTags(@NotNull JSONObject object) {
        if (!object.isNull("tags")) {
            this.writer.append("*tags:*");
            object.getJSONArray("tags").forEach(tag -> this.writer.append(" '").append((String)tag).append("'"));
            this.writer.println();
            this.writer.println();
        }
    }

    private void publishScenario(@NotNull JSONObject scenario) {
        this.writer.append(".Scenario: ").append(scenario.getString("name"));
        this.writer.println();
        this.writer.println("[%hardbreaks]");
        this.clause(scenario, "given");
        this.clause(scenario, "when");
        this.clause(scenario, "then");
        this.writer.println();
    }

    private void clause(@NotNull JSONObject scenario, @NotNull String clause) {
        JSONObject segment = (JSONObject)scenario.get(clause);
        this.writer.append("*").append(clause).append("* ").append(segment.getString("text"));
        JSONArray ands = segment.optJSONArray("and");
        if (ands != null) {
            ands.forEach(item -> this.writer.append(" *and* ").append((String)item));
        }
        this.writer.println();
    }

    private void header(@NotNull String text, int level) {
        this.writer.append("=".repeat(level)).append(" ").append(text).println();
        this.writer.println();
    }

    private void paragraph(@NotNull String text) {
        this.writer.append(text).println();
        this.writer.println();
    }
}

