/*
 * Decompiled with CFR 0.152.
 */
package net.tangly.bdd.engine;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.tangly.bdd.Scene;
import net.tangly.bdd.engine.StoryRun;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONObject;

public class StoryWriter {
    private static final Set<String> knownTargetDirs = Set.of("target", "build", "out");
    private final StoryRun run;
    private final Path path;

    public StoryWriter(@NotNull StoryRun run) {
        this.run = run;
        this.path = Paths.get(StoryWriter.getOrCreateBddReportsFolder(run.getClass()).toString(), run.clazz().getName() + ".json");
    }

    public static Path getOrCreateBddReportsFolder(@NotNull Class<?> clazz) {
        URL url = clazz.getResource("");
        Objects.requireNonNull(url);
        Path targetDir = Paths.get(url.getPath(), new String[0]);
        int index = targetDir.getNameCount() - 1;
        while (index > 0 && !knownTargetDirs.contains(targetDir.getName(index).toString())) {
            --index;
            targetDir = targetDir.getParent();
        }
        Path bddReportsDirectory = targetDir.resolve(Paths.get("bdd-reports", new String[0]));
        File bddReports = bddReportsDirectory.toFile();
        if (!bddReports.exists() && !bddReports.mkdir()) {
            throw new IllegalStateException("Unable to create the folder for saving bdd reports.");
        }
        return bddReportsDirectory;
    }

    void write() {
        JSONArray features = new JSONArray();
        JSONObject feature = StoryWriter.createFeature(this.run);
        features.put((Object)feature);
        JSONObject story = StoryWriter.createStory(this.run);
        feature.getJSONArray("stories").put((Object)story);
        for (Scene scene : this.run.scenes()) {
            story.getJSONArray("scenarios").put((Object)StoryWriter.createScenario(scene));
        }
        try (BufferedWriter writer = Files.newBufferedWriter(this.path, StandardCharsets.UTF_8, new OpenOption[0]);){
            writer.write(features.toString(4));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static JSONObject createFeature(StoryRun run) {
        JSONObject feature = new JSONObject();
        feature.put("package", (Object)run.packages().getName());
        feature.put("name", (Object)run.featureName());
        feature.put("id", (Object)run.featureId());
        feature.put("description", (Object)run.featureDescription());
        StoryWriter.createTags(run.featureTags(), feature);
        feature.put("stories", (Object)new JSONArray());
        return feature;
    }

    private static JSONObject createStory(StoryRun run) {
        JSONObject story = new JSONObject();
        story.put("class", (Object)run.clazz().getName());
        story.put("name", (Object)run.name());
        story.put("id", (Object)run.id());
        story.put("description", (Object)run.description());
        StoryWriter.createTags(run.storyTags(), story);
        story.put("scenarios", (Object)new JSONArray());
        return story;
    }

    private static JSONObject createScenario(@NotNull Scene scene) {
        JSONObject scenario = new JSONObject();
        scenario.put("method", (Object)scene.methodName());
        scenario.put("name", (Object)scene.description());
        if (!scene.given().text().isBlank()) {
            JSONObject given = new JSONObject();
            given.put("text", (Object)scene.given().text());
            StoryWriter.addAnds(scene.given().ands(), given);
            scenario.put("given", (Object)given);
        }
        if (!scene.when().text().isBlank()) {
            JSONObject when = new JSONObject();
            when.put("text", (Object)scene.when().text());
            scenario.put("when", (Object)when);
        }
        JSONObject then = new JSONObject();
        then.put("text", (Object)scene.then().text());
        StoryWriter.addAnds(scene.then().ands(), then);
        scenario.put("then", (Object)then);
        return scenario;
    }

    private static void addAnds(@NotNull List<String> ands, @NotNull JSONObject object) {
        StoryWriter.addList(ands, object, "and");
    }

    private static void createTags(@NotNull List<String> tags, @NotNull JSONObject object) {
        StoryWriter.addList(tags, object, "tags");
    }

    private static void addList(@NotNull List<String> items, @NotNull JSONObject object, String jsonTag) {
        if (!items.isEmpty()) {
            JSONArray jsonArray = new JSONArray();
            items.forEach(arg_0 -> ((JSONArray)jsonArray).put(arg_0));
            object.put(jsonTag, (Object)jsonArray);
        }
    }
}

