/*
 * Decompiled with CFR 0.152.
 */
package net.tangly.bdd.engine;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Optional;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoryMerger {
    private static final Logger logger = LoggerFactory.getLogger(StoryMerger.class);
    private final JSONArray features = new JSONArray();

    public void merge(@NotNull Path directory) throws IOException {
        try (Stream<Path> results = Files.walk(directory, new FileVisitOption[0]);){
            results.filter(t -> t.toString().endsWith(".json")).forEach(t -> {
                try (BufferedReader reader = Files.newBufferedReader(t, StandardCharsets.UTF_8);){
                    JSONArray report = new JSONArray(new JSONTokener((Reader)reader));
                    this.merge((JSONObject)report.get(0));
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
                catch (JSONException e) {
                    logger.atError().log("File {} is incorrect due to parallel writing", (Object)e);
                }
            });
        }
    }

    public void write(Path path) {
        try (BufferedWriter writer = Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]);){
            writer.write(this.features.toString(4));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void merge(JSONObject feature) {
        Optional<JSONObject> mergedFeature = StoryMerger.contains(this.features, "package", feature.getString("package"));
        if (mergedFeature.isEmpty()) {
            this.features.put((Object)feature);
        } else {
            JSONArray mergedStories = mergedFeature.get().getJSONArray("stories");
            JSONArray stories = feature.getJSONArray("stories");
            for (Object item : stories) {
                JSONObject story = (JSONObject)item;
                if (!StoryMerger.contains(mergedStories, "class", story.getString("class")).isEmpty()) continue;
                mergedStories.put((Object)story);
            }
        }
    }

    private static Optional<JSONObject> contains(JSONArray list, String key, String value) {
        for (Object item : list) {
            JSONObject object = (JSONObject)item;
            if (!object.has(key) || !object.getString(key).equals(value)) continue;
            return Optional.of(object);
        }
        return Optional.empty();
    }
}

