/*
 * Decompiled with CFR 0.152.
 */
package net.tangly.bdd.engine;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Parameter;
import net.tangly.bdd.Scenario;
import net.tangly.bdd.Scene;
import net.tangly.bdd.Story;
import net.tangly.bdd.engine.StoryRun;
import net.tangly.bdd.engine.StoryWriter;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.platform.commons.support.AnnotationSupport;

public class StoryExtension
implements BeforeAllCallback,
AfterAllCallback,
BeforeEachCallback,
ParameterResolver {
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{StoryExtension.class});

    public void beforeAll(ExtensionContext context) {
        if (!StoryExtension.isStory(context)) {
            throw new IllegalStateException("Use @Story annotation to use Story Extension. Class: " + context.getRequiredTestClass());
        }
        Class clazz = context.getRequiredTestClass();
        StoryRun storyRun = new StoryRun(clazz);
        context.getStore(NAMESPACE).put((Object)clazz.getName(), (Object)storyRun);
    }

    public void afterAll(ExtensionContext context) {
        if (StoryExtension.isStory(context)) {
            new StoryWriter(StoryExtension.storyDetails(context)).write();
        }
    }

    public void beforeEach(ExtensionContext context) {
        if (!StoryExtension.isScenario(context)) {
            throw new IllegalStateException("Use @Scenario annotation to use the StoryExtension service. Method: " + context.getRequiredTestMethod());
        }
        Scene scene = new Scene(context.getRequiredTestMethod());
        StoryExtension.storyDetails(context).addScene(scene);
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        Parameter parameter = parameterContext.getParameter();
        return Scene.class.equals(parameter.getType());
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext context) {
        return StoryExtension.storyDetails(context).findSceneByMethodName(context.getRequiredTestMethod().getName());
    }

    private static StoryRun storyDetails(ExtensionContext context) {
        Class clazz = context.getRequiredTestClass();
        return (StoryRun)context.getStore(NAMESPACE).get((Object)clazz.getName(), StoryRun.class);
    }

    private static boolean isStory(ExtensionContext context) {
        return AnnotationSupport.isAnnotated((AnnotatedElement)context.getRequiredTestClass(), Story.class);
    }

    private static boolean isScenario(ExtensionContext context) {
        return AnnotationSupport.isAnnotated((AnnotatedElement)context.getRequiredTestMethod(), Scenario.class);
    }
}

