/*
 * Decompiled with CFR 0.152.
 */
package net.tangly.bdd;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import net.tangly.bdd.Phase;
import net.tangly.bdd.Scenario;
import org.jetbrains.annotations.NotNull;

public class Scene {
    private final Method method;
    private final Map<String, Object> values;
    private Phase current;
    private Phase given;
    private Phase when;
    private Phase then;

    public Scene(@NotNull Method method) {
        this.method = method;
        this.values = new HashMap<String, Object>();
    }

    public void put(String key, Object value) {
        this.values.put(key, value);
    }

    public Object get(String key) {
        return this.values.get(key);
    }

    public String methodName() {
        return this.method.getName();
    }

    public String description() {
        return this.method.getAnnotation(Scenario.class).value();
    }

    public Scene given(String description, Consumer<Scene> given) {
        if (this.given != null || this.when != null || this.then != null) {
            throw new IllegalStateException("Cannot define more than one \"given\" phase or after a \"when\" or \"then\" phase.");
        }
        this.current = this.given = new Phase(description, given);
        return this;
    }

    public Scene when(String description, Consumer<Scene> when) {
        if (this.when != null || this.then != null) {
            throw new IllegalStateException("Cannot define more than one \"when\" phase or after a \"then\" phase.");
        }
        this.current = this.when = new Phase(description, when);
        return this;
    }

    public Scene then(String description, Consumer<Scene> then) {
        if (this.then != null) {
            throw new IllegalStateException("Cannot define more than one \"then\" phase.");
        }
        this.current = this.then = new Phase(description, then);
        return this;
    }

    public Scene and(String description, Consumer<Scene> and) {
        if (this.current == null) {
            throw new IllegalStateException("Start your scene with \"given\" or \"when\" pr \"then\" phase.");
        }
        this.current.and(description, and);
        return this;
    }

    public Scene run() {
        Objects.requireNonNull(this.given, "Start your scene with a \"given\" phase");
        Objects.requireNonNull(this.when, "Start your scene with a \"when\" phase");
        Objects.requireNonNull(this.then, "End your scene with a \"then\" phase");
        this.given.lambda().accept(this);
        this.when.lambda().accept(this);
        this.then.lambda().accept(this);
        return this;
    }

    public Phase given() {
        return this.given;
    }

    public Phase when() {
        return this.when;
    }

    public Phase then() {
        return this.then;
    }
}

