/*
 * Decompiled with CFR 0.152.
 */
package net.tangly.bdd.engine;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.tangly.bdd.Scene;
import net.tangly.bdd.engine.StoryRun;
import org.json.JSONArray;
import org.json.JSONObject;

public class StoryWriter {
    private static final Set<String> knownTargetDirs = Set.of("target", "build", "out");
    private final StoryRun run;
    private final Path path;

    public static Path getOrCreateBddReportsFolder(Class<?> clazz) {
        URL url = clazz.getResource("");
        Objects.requireNonNull(url);
        Path targetDir = Paths.get(url.getPath(), new String[0]);
        int index = targetDir.getNameCount() - 1;
        while (index > 0 && !knownTargetDirs.contains(targetDir.getName(index).toString())) {
            --index;
            targetDir = targetDir.getParent();
        }
        Path bddReportsDirectory = targetDir.resolve(Paths.get("bdd-reports", new String[0]));
        File bddReports = bddReportsDirectory.toFile();
        if (!bddReports.exists() && !bddReports.mkdir()) {
            throw new RuntimeException("Unable to create the folder for saving bdd reports.");
        }
        return bddReportsDirectory;
    }

    public StoryWriter(StoryRun run) {
        this.run = run;
        this.path = Paths.get(StoryWriter.getOrCreateBddReportsFolder(run.getClass()).toString(), run.clazz().getName() + ".json");
    }

    void write() {
        JSONArray features = new JSONArray();
        JSONObject feature = this.createFeature();
        features.put((Object)feature);
        JSONObject story = this.createStory();
        feature.getJSONArray("stories").put((Object)story);
        for (Scene scene : this.run.scenes()) {
            story.getJSONArray("scenarios").put((Object)this.createScenario(scene));
        }
        try (BufferedWriter writer = Files.newBufferedWriter(this.path, StandardCharsets.UTF_8, new OpenOption[0]);){
            writer.write(features.toString(4));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private JSONObject createFeature() {
        JSONObject feature = new JSONObject();
        feature.put("package", (Object)this.run.packages().getName());
        feature.put("name", (Object)this.run.featureName());
        feature.put("id", (Object)this.run.featureId());
        feature.put("description", (Object)this.run.featureDescription());
        feature.put("stories", (Object)new JSONArray());
        return feature;
    }

    private JSONObject createStory() {
        JSONObject story = new JSONObject();
        story.put("class", (Object)this.run.clazz().getName());
        story.put("name", (Object)this.run.name());
        story.put("id", (Object)this.run.id());
        story.put("description", (Object)this.run.description());
        story.put("scenarios", (Object)new JSONArray());
        return story;
    }

    private JSONObject createScenario(Scene scene) {
        JSONObject scenario = new JSONObject();
        scenario.put("method", (Object)scene.methodName());
        scenario.put("name", (Object)scene.description());
        if (!scene.given().text().isBlank()) {
            JSONObject given = new JSONObject();
            given.put("text", (Object)scene.given().text());
            this.addAnds(scene.given().ands(), given);
            scenario.put("given", (Object)given);
        }
        if (!scene.when().text().isBlank()) {
            JSONObject when = new JSONObject();
            when.put("text", (Object)scene.when().text());
            scenario.put("when", (Object)when);
        }
        JSONObject then = new JSONObject();
        then.put("text", (Object)scene.then().text());
        this.addAnds(scene.then().ands(), then);
        scenario.put("then", (Object)then);
        return scenario;
    }

    private void addAnds(List<String> ands, JSONObject jsonObject) {
        if (!ands.isEmpty()) {
            JSONArray jsonArray = new JSONArray();
            ands.forEach(arg_0 -> ((JSONArray)jsonArray).put(arg_0));
            jsonObject.put("and", (Object)jsonArray);
        }
    }
}

