/*
 * Decompiled with CFR 0.152.
 */
package net.tangly.bdd.engine;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.tangly.bdd.Feature;
import net.tangly.bdd.Scene;
import net.tangly.bdd.Story;

class StoryRun {
    private final Class<?> clazz;
    private final List<Scene> scenes;

    public StoryRun(Class<?> clazz) {
        this.clazz = clazz;
        this.scenes = new ArrayList<Scene>();
    }

    public String name() {
        Story story = this.clazz.getAnnotation(Story.class);
        return story.value();
    }

    public String id() {
        Story story = this.clazz.getAnnotation(Story.class);
        return story.id();
    }

    public String description() {
        Story story = this.clazz.getAnnotation(Story.class);
        return story.description();
    }

    public Class<?> clazz() {
        return this.clazz;
    }

    public String featureName() {
        Feature feature = this.clazz.getPackage().getAnnotation(Feature.class);
        return feature.value();
    }

    public String featureId() {
        Feature feature = this.clazz.getPackage().getAnnotation(Feature.class);
        return feature.id();
    }

    public String featureDescription() {
        Feature feature = this.clazz.getPackage().getAnnotation(Feature.class);
        return feature.description();
    }

    public Package packages() {
        return this.clazz.getPackage();
    }

    public void addScene(Scene scene) {
        this.scenes.add(scene);
    }

    public List<Scene> scenes() {
        return Collections.unmodifiableList(this.scenes);
    }

    public Scene findSceneByMethodName(String name) {
        return this.scenes.stream().filter(o -> name.equals(o.methodName())).findAny().orElse(null);
    }
}

