/*
 * Decompiled with CFR 0.152.
 */
package net.tangly.bdd.engine;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONTokener;

public class StoryAsciiDocPublisher {
    public static final String NEWLINE = " +" + System.lineSeparator();
    private final PrintWriter writer;

    public StoryAsciiDocPublisher(Path bddReport, Path report) throws IOException {
        try (BufferedReader reader = Files.newBufferedReader(bddReport, StandardCharsets.UTF_8);){
            JSONArray features = new JSONArray(new JSONTokener((Reader)reader));
            this.writer = new PrintWriter(report.toFile());
            this.header();
            for (Object item : features) {
                this.publishFeature((JSONObject)item);
            }
            this.writer.flush();
            this.writer.close();
        }
    }

    private void header() {
        this.writer.println("---");
        this.writer.println("title: \"bdd Report\"");
        this.writer.println("date: 2020-01-01");
        this.writer.println("weight: 60");
        this.writer.println("draft: false");
        this.writer.println("---");
        this.writer.println();
    }

    private void publishFeature(JSONObject feature) {
        this.header(feature.getString("name"), 2);
        this.paragraph(feature.getString("description"));
        for (Object item : feature.getJSONArray("stories")) {
            this.publishStory((JSONObject)item);
        }
    }

    private void publishStory(JSONObject story) {
        this.header(story.getString("name"), 3);
        this.paragraph(story.getString("description"));
        for (Object item : story.getJSONArray("scenarios")) {
            this.publishScenario((JSONObject)item);
        }
    }

    private void publishScenario(JSONObject scenario) {
        this.header(scenario.getString("name"), 4);
        this.writer.println("[%hardbreaks]");
        this.clause(scenario, "given");
        this.clause(scenario, "when");
        this.clause(scenario, "then");
        this.writer.println();
    }

    private void clause(JSONObject scenario, String clause) {
        JSONObject segment = (JSONObject)scenario.get(clause);
        this.writer.append("*" + clause + "* " + segment.getString("text"));
        JSONArray ands = segment.optJSONArray("and");
        if (ands != null) {
            for (Object item : ands) {
                this.writer.append(" *and* " + (String)item);
            }
        }
        this.writer.println();
    }

    private void header(String text, int level) {
        this.writer.append("=".repeat(level)).append(" ").append(text).println();
        this.writer.println();
    }

    private void paragraph(String text) {
        this.writer.append(text).println();
        this.writer.println();
    }
}

