/*
 * Decompiled with CFR 0.152.
 */
package net.tangly.app.ui;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.HtmlComponent;
import com.vaadin.flow.component.Unit;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.formlayout.FormLayout;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.html.Image;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.textfield.PasswordField;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.binder.ValidationException;
import com.vaadin.flow.function.ValueProvider;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.server.AbstractStreamResource;
import com.vaadin.flow.server.InputStreamFactory;
import com.vaadin.flow.server.StreamResource;
import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import net.tangly.app.services.AppsBoundedDomain;
import net.tangly.app.services.AppsRealm;
import net.tangly.app.ui.AccessRightsView;
import net.tangly.app.ui.AppsBoundedDomainUi;
import net.tangly.commons.lang.Strings;
import net.tangly.core.domain.AccessRights;
import net.tangly.core.domain.User;
import net.tangly.ui.app.domain.BoundedDomainUi;
import net.tangly.ui.components.ItemForm;
import net.tangly.ui.components.ItemView;
import net.tangly.ui.components.Mode;
import net.tangly.ui.components.One2ManyOwnedField;
import net.tangly.ui.components.VaadinUtils;
import org.jetbrains.annotations.NotNull;

@PageTitle(value="products-efforts")
class UsersView
extends ItemView<User> {
    public UsersView(@NotNull AppsBoundedDomainUi domain, @NotNull Mode mode) {
        super(User.class, (BoundedDomainUi)domain, ((AppsRealm)((AppsBoundedDomain)domain.domain()).realm()).users(), null, mode);
        this.form(() -> new UserForm(this));
        this.init();
    }

    private void init() {
        Grid grid = this.grid();
        ((Grid.Column)grid.addColumn(User::username).setKey("username").setHeader("Username").setAutoWidth(true).setResizable(true)).setSortable(true);
        ((Grid.Column)grid.addColumn(User::gravatarEmail).setKey("gravatarEmail").setHeader("Gravatar Email").setAutoWidth(true).setResizable(true)).setSortable(true);
        VaadinUtils.addColumnBoolean((Grid)grid, User::active, (String)"active", (String)"Active");
    }

    static class UserForm
    extends ItemForm<User, UsersView> {
        private final Image image = new Image();
        private final TextField username;
        private final PasswordField password;
        private final TextField gravatarEmail;
        private final Checkbox active;
        private final TextField naturalPersonId;
        private final One2ManyOwnedField<AccessRights> rights;

        UserForm(@NotNull UsersView view) {
            super((ItemView)view);
            this.image.setWidth(200.0f, Unit.PIXELS);
            this.image.setHeight(200.0f, Unit.PIXELS);
            this.username = VaadinUtils.createTextField((String)"Username", (String)"username");
            this.username.setRequired(true);
            this.password = new PasswordField("Password");
            this.gravatarEmail = VaadinUtils.createTextField((String)"Gravatar Email", (String)"gravatar email");
            this.active = new Checkbox("Active");
            this.naturalPersonId = VaadinUtils.createTextField((String)"Person Id", (String)"natural person id");
            this.rights = new One2ManyOwnedField((ItemView)new AccessRightsView(view.domainUi(), Mode.EDITABLE));
            this.binder().bindReadOnly(this.rights, User::accessRights);
            this.addTabAt("details", (Component)this.details(), 0);
            this.addTabAt("access rights", (Component)this.rights, 1);
        }

        public void value(User value) {
            super.value((Object)value);
            if (Objects.nonNull(value) && Objects.nonNull(value.gravatarEmail())) {
                byte[] photo = User.avatar((String)value.gravatarEmail());
                this.image.setSrc((AbstractStreamResource)new StreamResource("photo.jpg", (InputStreamFactory & Serializable)() -> new ByteArrayInputStream(photo)));
            }
        }

        protected void closeForm() {
            this.password.setRequired(false);
            this.password.setEnabled(false);
            super.closeForm();
        }

        public void create() {
            super.create();
            this.password.setEnabled(true);
            this.password.setRequired(true);
        }

        public void duplicate(@NotNull User entity) {
            super.duplicate((Object)entity);
            this.password.setEnabled(true);
            this.password.setRequired(true);
        }

        protected User createOrUpdateInstance(User entity) throws ValidationException {
            String newPassword = null;
            String newSalt = User.newSalt();
            if (!Strings.isNullOrBlank((String)this.password.getValue())) {
                newPassword = User.encryptPassword((String)this.password.getValue(), (String)newSalt);
            } else if (entity != null) {
                newPassword = entity.passwordHash();
                newSalt = entity.passwordSalt();
            }
            return new User(this.username.getValue(), newPassword, newSalt, ((Boolean)this.active.getValue()).booleanValue(), this.naturalPersonId.getValue(), List.copyOf((Collection)this.rights.getValue()), this.gravatarEmail.getValue());
        }

        private FormLayout details() {
            FormLayout form = new FormLayout();
            form.add(new Component[]{this.username, this.password, this.gravatarEmail, this.active, this.naturalPersonId});
            form.add(new Component[]{new HtmlComponent("br")});
            form.add(new Component[]{new VerticalLayout(new Component[]{this.image})});
            this.binder().bindReadOnly((HasValue)this.username, (ValueProvider & Serializable)o -> o.username());
            this.binder().bindReadOnly((HasValue)this.gravatarEmail, (ValueProvider & Serializable)o -> o.gravatarEmail());
            this.binder().bindReadOnly((HasValue)this.active, (ValueProvider & Serializable)o -> o.active());
            this.binder().bindReadOnly((HasValue)this.naturalPersonId, (ValueProvider & Serializable)o -> o.naturalPersonId());
            return form;
        }
    }
}

