/*
 * Decompiled with CFR 0.152.
 */
package net.tangly.app.ui;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.login.LoginI18n;
import com.vaadin.flow.component.login.LoginOverlay;
import com.vaadin.flow.component.notification.Notification;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import net.tangly.app.Application;
import net.tangly.app.ApplicationView;
import net.tangly.app.Tenant;
import net.tangly.app.services.AppsBusinessLogic;
import net.tangly.core.domain.User;
import net.tangly.ui.app.domain.Cmd;
import net.tangly.ui.components.VaadinUtils;
import org.jetbrains.annotations.NotNull;

public record CmdLogin(@NotNull ApplicationView applicationView) implements Cmd
{
    public void execute() {
        LoginOverlay component = new LoginOverlay();
        LoginI18n i18n = LoginI18n.createDefault();
        i18n.setHeader(new LoginI18n.Header());
        i18n.getHeader().setTitle("tangly ERP");
        i18n.getHeader().setDescription("tangly llc ERP Application");
        component.setI18n(i18n);
        component.setOpened(true);
        component.addLoginListener((ComponentEventListener & Serializable)e -> {
            String[] credentials = e.getUsername().split("/");
            Tenant tenant = Application.instance().tenant(credentials[0]);
            if (Objects.nonNull(tenant)) {
                Optional<User> user = ((AppsBusinessLogic)tenant.apps().logic()).login(credentials[1], e.getPassword());
                if (user.isPresent()) {
                    VaadinUtils.setAttribute((Component)component, (String)"user", (Object)user.get());
                    VaadinUtils.setAttribute((Component)component, (String)"username", (Object)user.get().username());
                    this.applicationView.userChanged(tenant, user.get());
                    component.close();
                } else {
                    component.setError(true);
                }
            } else {
                component.setError(true);
            }
        });
        component.addForgotPasswordListener((ComponentEventListener & Serializable)e -> Notification.show((String)"Please contact tangly llc under info@tangly.net"));
    }
}

