/*
 * Decompiled with CFR 0.152.
 */
package net.tangly.app.ui;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.HtmlComponent;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.formlayout.FormLayout;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.textfield.PasswordField;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.binder.Binder;
import com.vaadin.flow.data.binder.ValidationException;
import com.vaadin.flow.function.SerializablePredicate;
import com.vaadin.flow.function.ValueProvider;
import java.io.Serializable;
import java.util.Objects;
import net.tangly.app.services.AppsBoundedDomain;
import net.tangly.app.services.AppsBusinessLogic;
import net.tangly.core.domain.User;
import net.tangly.ui.app.domain.Cmd;
import net.tangly.ui.components.VaadinUtils;
import org.jetbrains.annotations.NotNull;

public class CmdChangePassword
implements Cmd {
    public static final String USERNAME = "Username";
    public static final String CURRENT_PASSWORD = "Current Password";
    public static final String NEW_PASSWORD = "New Password";
    public static final String CONFIRM_PASSWORD = "Confirm New Password";
    public static final String EXECUTE = "Update";
    public static final String CANCEL = "Cancel";
    private final ChangePassword changePassword;
    private final TextField username;
    private final PasswordField oldPassword;
    private final PasswordField newPassword;
    private final PasswordField confirmPassword;
    private final AppsBoundedDomain domain;
    private Dialog dialog;

    public CmdChangePassword(@NotNull AppsBoundedDomain domain, @NotNull User subject) {
        this.domain = domain;
        this.changePassword = new ChangePassword(subject);
        this.username = new TextField(USERNAME, "username");
        this.username.setReadOnly(true);
        this.oldPassword = new PasswordField(CURRENT_PASSWORD, "old password");
        this.oldPassword.setRequired(true);
        this.newPassword = new PasswordField(NEW_PASSWORD, "new password");
        this.newPassword.setRequired(true);
        this.confirmPassword = new PasswordField(CONFIRM_PASSWORD, "new password");
        this.confirmPassword.setRequired(true);
    }

    public void execute() {
        this.dialog = new Dialog();
        this.dialog.setWidth("40em");
        FormLayout form = new FormLayout();
        VaadinUtils.set1ResponsiveSteps((FormLayout)form);
        Binder binder = new Binder();
        binder.bind((HasValue)this.username, (ValueProvider & Serializable)o -> o.user().username(), null);
        binder.bind((HasValue)this.oldPassword, ChangePassword::oldPassword, ChangePassword::oldPassword);
        binder.bind((HasValue)this.newPassword, ChangePassword::newPassword, ChangePassword::newPassword);
        binder.forField((HasValue)this.confirmPassword).withValidator((SerializablePredicate & Serializable)v -> Objects.equals(this.newPassword.getValue(), v), "new password and confirm password should the same text").bind(ChangePassword::confirmPassword, ChangePassword::confirmPassword);
        binder.readBean((Object)this.changePassword);
        Button execute = new Button(EXECUTE, (Component)VaadinIcon.COGS.create(), (ComponentEventListener & Serializable)e -> {
            try {
                binder.writeBean((Object)this.changePassword);
                ((AppsBusinessLogic)this.domain.logic()).changePassword(this.changePassword.user().username(), this.changePassword.oldPassword(), this.changePassword.newPassword());
                this.dialog.close();
                this.dialog = null;
            }
            catch (ValidationException validationException) {
                // empty catch block
            }
        });
        Button cancel = new Button(CANCEL, (ComponentEventListener & Serializable)e -> this.dialog.close());
        form.add(new Component[]{this.username, this.oldPassword, this.newPassword, this.confirmPassword, new HtmlComponent("br"), new HorizontalLayout(new Component[]{execute, cancel})});
        this.dialog.add(new Component[]{form});
        this.dialog.open();
    }

    public Dialog dialog() {
        return this.dialog;
    }

    static class ChangePassword {
        private final User user;
        private String oldPassword;
        private String newPassword;
        private String confirmPassword;

        ChangePassword(User subject) {
            this.user = subject;
        }

        public User user() {
            return this.user;
        }

        String oldPassword() {
            return this.oldPassword;
        }

        void oldPassword(String oldPassword) {
            this.oldPassword = oldPassword;
        }

        String newPassword() {
            return this.newPassword;
        }

        void newPassword(String newPassword) {
            this.newPassword = newPassword;
        }

        String confirmPassword() {
            return this.confirmPassword;
        }

        void confirmPassword(String confirmPassword) {
            this.confirmPassword = confirmPassword;
        }
    }
}

