/*
 * Decompiled with CFR 0.152.
 */
package net.tangly.app.ui;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.formlayout.FormLayout;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.textfield.TextField;
import net.tangly.app.ApplicationView;
import net.tangly.core.codes.CodeType;
import net.tangly.core.domain.AccessRights;
import net.tangly.core.domain.AccessRightsCode;
import net.tangly.core.providers.ProviderInMemory;
import net.tangly.ui.app.domain.BoundedDomainUi;
import net.tangly.ui.components.ItemForm;
import net.tangly.ui.components.ItemView;
import net.tangly.ui.components.Mode;
import net.tangly.ui.components.VaadinUtils;
import org.jetbrains.annotations.NotNull;

public class AccessRightsView
extends ItemView<AccessRights> {
    private static final String USERNAME = "username";
    private static final String ACCESS_RIGHT_CODE = "accessRightCode";
    private static final String USERNAME_LABEL = "Username";
    private static final String ACCESS_RIGHT_CODE_LABEL = "Access Right";

    public AccessRightsView(@NotNull BoundedDomainUi<?> domain, @NotNull Mode mode) {
        super(AccessRights.class, domain, ProviderInMemory.of(), null, mode);
        this.form(() -> new AccessRightsForm(this));
        this.init();
    }

    private void init() {
        this.setHeight("15em");
        Grid grid = this.grid();
        ((Grid.Column)grid.addColumn(AccessRights::username).setKey(USERNAME).setHeader(USERNAME_LABEL).setSortable(true).setResizable(true)).setFlexGrow(0).setWidth("10em");
        ((Grid.Column)grid.addColumn(AccessRights::domain).setKey("domain").setHeader("DOMAIN").setSortable(true).setResizable(true)).setFlexGrow(0).setWidth("10em");
        ((Grid.Column)grid.addColumn(AccessRights::right).setKey(ACCESS_RIGHT_CODE).setHeader(ACCESS_RIGHT_CODE_LABEL).setSortable(true).setResizable(true)).setFlexGrow(0).setWidth("25em");
    }

    static class AccessRightsForm
    extends ItemForm<AccessRights, AccessRightsView> {
        private final TextField username = VaadinUtils.createTextField((String)"Username", (String)"username");
        private final TextField domain = VaadinUtils.createTextField((String)"Domain", (String)"domain");
        private final ComboBox<AccessRightsCode> gender = ItemForm.createCodeField((CodeType)CodeType.of(AccessRightsCode.class), (String)"Gender");

        public AccessRightsForm(@NotNull AccessRightsView view) {
            super((ItemView)view);
            this.init();
        }

        public void create() {
            super.create();
            this.username.setValue(ApplicationView.username());
        }

        protected AccessRights createOrUpdateInstance(AccessRights entity) {
            AccessRights rights = new AccessRights(this.username.getValue(), this.domain.getValue(), null);
            ((AccessRightsView)this.view()).provider().replace((Object)entity, (Object)rights);
            return rights;
        }

        private void init() {
            FormLayout layout = new FormLayout();
            layout.add(new Component[]{this.username, this.domain, null});
            this.form().add(new Component[]{layout, this.createButtonBar()});
            this.binder().forField((HasValue)this.username).bindReadOnly(AccessRights::username);
            this.binder().forField((HasValue)this.domain).bindReadOnly(AccessRights::domain);
        }
    }
}

