/*
 * Decompiled with CFR 0.152.
 */
package net.tangly.app.services;

import java.util.List;
import java.util.Optional;
import net.tangly.app.services.AppsRealm;
import net.tangly.core.domain.User;
import org.jetbrains.annotations.NotNull;

public class AppsBusinessLogic {
    private final AppsRealm realm;

    public AppsBusinessLogic(@NotNull AppsRealm realm) {
        this.realm = realm;
    }

    public AppsRealm realm() {
        return this.realm;
    }

    public List<String> activeUsersFor(String domain) {
        return this.realm().users().items().stream().filter(o -> o.active() && o.accessRightsFor(domain).isPresent()).map(User::username).toList();
    }

    public List<String> usersFor(String domain) {
        return this.realm().users().items().stream().filter(o -> o.accessRightsFor(domain).isPresent()).map(User::username).toList();
    }

    public Optional<User> login(@NotNull String username, @NotNull String password) {
        return this.realm().users().items().stream().filter(o -> o.username().equals(username) && o.authenticate(password)).findAny();
    }

    public boolean changePassword(String username, String password, String newPassword) {
        Optional<User> user = this.realm().users().items().stream().filter(o -> o.username().equals(username) && o.authenticate(password)).findAny();
        user.ifPresent(o -> {
            String passwordHash = User.encryptPassword((String)newPassword, (String)o.passwordSalt());
            User updatedUser = new User(o.username(), passwordHash, o.passwordSalt(), o.active(), o.naturalPersonId(), o.accessRights(), o.gravatarEmail());
            this.realm().users().replace(o, (Object)updatedUser);
        });
        return user.isPresent();
    }
}

