/*
 * Decompiled with CFR 0.152.
 */
package net.tangly.app.ports;

import java.nio.file.Path;
import java.util.List;
import java.util.function.Function;
import net.tangly.app.services.AppsRealm;
import net.tangly.core.domain.AccessRights;
import net.tangly.core.domain.AccessRightsCode;
import net.tangly.core.domain.DomainAudit;
import net.tangly.core.domain.TsvHdl;
import net.tangly.core.domain.User;
import net.tangly.core.providers.Provider;
import net.tangly.core.providers.ProviderInMemory;
import net.tangly.gleam.model.TsvEntity;
import net.tangly.gleam.model.TsvProperty;
import org.apache.commons.csv.CSVRecord;
import org.jetbrains.annotations.NotNull;

public class AppsTsvHdl {
    public static final String USERNAME = "username";
    public static final String PASSWORD_HASH = "passwordHash";
    public static final String PASSWORD_SALT = "passwordSalt";
    public static final String ACTIVE = "active";
    public static final String GRAVATAR_EMAIL = "gravatarEmail";
    public static final String NATURAL_ENTITY_ID = "naturalEntityId";
    public static final String RIGHTS = "rights";
    private final AppsRealm realm;

    public AppsTsvHdl(@NotNull AppsRealm realm) {
        this.realm = realm;
    }

    public void importUsers(@NotNull DomainAudit audit, @NotNull Path userPath, @NotNull Path accessRighsPath) {
        ProviderInMemory rights = new ProviderInMemory();
        TsvHdl.importEntities((DomainAudit)audit, (Path)accessRighsPath, AppsTsvHdl.createTsvAccessRights(), (Provider)rights);
        TsvHdl.importEntities((DomainAudit)audit, (Path)userPath, AppsTsvHdl.createTsvUser(rights.items()), this.realm.users());
    }

    public void exportUsers(@NotNull DomainAudit audit, @NotNull Path usersPath, @NotNull Path accessRightsPath) {
        Provider rights = ProviderInMemory.of(this.realm.users().items().stream().flatMap(o -> o.accessRights().stream()).toList());
        TsvHdl.exportEntities((DomainAudit)audit, (Path)usersPath, AppsTsvHdl.createTsvUser(rights.items()), this.realm.users());
        TsvHdl.exportEntities((DomainAudit)audit, (Path)accessRightsPath, AppsTsvHdl.createTsvAccessRights(), (Provider)rights);
    }

    private static TsvEntity<User> createTsvUser(@NotNull List<AccessRights> rights) {
        Function<CSVRecord, User> imports = o -> {
            String username = TsvEntity.get((CSVRecord)o, (String)USERNAME);
            List<AccessRights> accessRights = AppsTsvHdl.accessRights(rights, username);
            return new User(username, TsvEntity.get((CSVRecord)o, (String)PASSWORD_HASH), TsvEntity.get((CSVRecord)o, (String)PASSWORD_SALT), true, TsvEntity.get((CSVRecord)o, (String)NATURAL_ENTITY_ID), accessRights, TsvHdl.parseString((CSVRecord)o, (String)GRAVATAR_EMAIL));
        };
        List<TsvProperty> fields = List.of(TsvProperty.ofString((String)USERNAME, User::username), TsvProperty.ofString((String)PASSWORD_HASH, User::passwordHash), TsvProperty.ofString((String)PASSWORD_SALT, User::passwordSalt), TsvProperty.ofBoolean((String)ACTIVE, User::active), TsvProperty.ofString((String)NATURAL_ENTITY_ID, User::naturalPersonId), TsvProperty.ofString((String)GRAVATAR_EMAIL, User::gravatarEmail));
        return TsvEntity.of(User.class, fields, imports);
    }

    private static TsvEntity<AccessRights> createTsvAccessRights() {
        Function<CSVRecord, AccessRights> imports = o -> new AccessRights(TsvEntity.get((CSVRecord)o, (String)USERNAME), TsvEntity.get((CSVRecord)o, (String)"domain"), (AccessRightsCode)TsvHdl.parseEnum((CSVRecord)o, (String)RIGHTS, AccessRightsCode.class));
        List<TsvProperty> fields = List.of(TsvProperty.ofString((String)USERNAME, AccessRights::username), TsvProperty.ofString((String)"domain", AccessRights::domain), TsvProperty.ofEnum(AccessRightsCode.class, (String)RIGHTS, AccessRights::right));
        return TsvEntity.of(AccessRights.class, fields, imports);
    }

    private static List<AccessRights> accessRights(@NotNull List<AccessRights> rights, String username) {
        return rights.stream().filter(o -> o.username().equals(username)).toList();
    }
}

