/*
 * Decompiled with CFR 0.152.
 */
package net.tangly.app.ports;

import java.nio.file.Path;
import net.tangly.app.ports.AppsTsvHdl;
import net.tangly.app.services.AppsPort;
import net.tangly.app.services.AppsRealm;
import net.tangly.core.domain.AccessRights;
import net.tangly.core.domain.DomainAudit;
import net.tangly.core.domain.Port;
import net.tangly.core.domain.User;
import org.jetbrains.annotations.NotNull;

public class AppsAdapter
implements AppsPort {
    public static final String USERS_TSV = "users.tsv";
    public static final String ACCESS_RIGHTS_TSV = "access-rights.tsv";
    private final AppsRealm realm;
    private final Path dataFolder;

    public AppsAdapter(@NotNull AppsRealm realm, @NotNull Path dataFolder) {
        this.realm = realm;
        this.dataFolder = dataFolder;
    }

    public AppsRealm realm() {
        return this.realm;
    }

    public void importEntities(@NotNull DomainAudit audit) {
        AppsTsvHdl handler = new AppsTsvHdl(this.realm);
        handler.importUsers(audit, this.dataFolder.resolve(USERS_TSV), this.dataFolder.resolve(ACCESS_RIGHTS_TSV));
        this.entitiesImported(audit);
    }

    public void exportEntities(@NotNull DomainAudit audit) {
        AppsTsvHdl handler = new AppsTsvHdl(this.realm);
        handler.exportUsers(audit, this.dataFolder.resolve(USERS_TSV), this.dataFolder.resolve(ACCESS_RIGHTS_TSV));
    }

    public void clearEntities(@NotNull DomainAudit audit) {
        this.realm().users().deleteAll();
        Port.entitiesCleared((DomainAudit)audit, (String)User.class.getSimpleName());
        this.entitiesImported(audit);
    }

    private void entitiesImported(@NotNull DomainAudit audit) {
        audit.entityImported(User.class.getSimpleName());
        audit.entityImported(AccessRights.class.getSimpleName());
    }
}

