/*
 * Decompiled with CFR 0.152.
 */
package net.tangly.app;

import io.javalin.Javalin;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import net.tangly.app.api.BoundedDomainRest;
import net.tangly.app.ports.AppsAdapter;
import net.tangly.app.ports.AppsEntities;
import net.tangly.app.services.AppsBoundedDomain;
import net.tangly.app.services.AppsBusinessLogic;
import net.tangly.core.domain.BoundedDomain;
import net.tangly.core.domain.TenantDirectory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class Tenant
implements TenantDirectory {
    public static final String IN_MEMORY_PROPERTY = "tenant.in-memory";
    public static final String TENANT_ROOT_DIRECTORY_PROPERTY = "tenant.root.directory";
    public static final String TENANT_ARCHIVE_DRECTORY_PROPERTY = "tenant.archive.directory";
    public static final String DATABASES_DIRECTORY_PROPERTY = "tenant.root.db.directory";
    public static final String IMPORTS_DIRECTORY_PROPERTY = "tenant.root.imports.directory";
    public static final String DOCUMENTS_DIRECTORY_PROPERTY = "tenant.root.docs.directory";
    private static final Logger logger = LogManager.getLogger();
    private final String id;
    private final Properties properties;
    private final Map<String, BoundedDomain<?, ?, ?>> boundedDomains;
    private final Map<String, BoundedDomainRest> boundedDomainRests;

    public Tenant(@NotNull Properties properties) {
        Objects.requireNonNull(properties.get("tenant.id"), "The tenant id is mandatory");
        this.id = properties.getProperty("tenant.id");
        this.properties = properties;
        this.boundedDomains = new HashMap();
        this.boundedDomainRests = new HashMap<String, BoundedDomainRest>();
        this.ofAppDomain();
    }

    public String id() {
        return this.id;
    }

    public String getProperty(@NotNull String property) {
        return this.properties.getProperty(property);
    }

    public Collection<BoundedDomain<?, ?, ?>> boundedDomains() {
        return this.boundedDomains.values();
    }

    public Optional<BoundedDomain<?, ?, ?>> getBoundedDomain(@NotNull String name) {
        return Optional.ofNullable(this.boundedDomains.get(name));
    }

    public List<String> usersFor(@NotNull String domain) {
        return ((AppsBusinessLogic)this.apps().logic()).usersFor(domain);
    }

    public List<String> activeUsersFor(@NotNull String domain) {
        return ((AppsBusinessLogic)this.apps().logic()).activeUsersFor(domain);
    }

    public String docs(@NotNull String domain) {
        return "%s/%s".formatted(this.getProperty(DOCUMENTS_DIRECTORY_PROPERTY), domain);
    }

    public boolean isEnabled(@NotNull String domain) {
        return Boolean.parseBoolean(this.properties.getProperty("%s.enabled".formatted(domain), "true"));
    }

    public Properties properties() {
        return this.properties;
    }

    public void startup(@NotNull Javalin javalin) {
        this.boundedDomains.values().forEach(BoundedDomain::startup);
        this.boundedDomainRests.values().forEach(o -> o.registerEndPoints(javalin));
    }

    public void shutdown() {
        this.boundedDomains.values().forEach(BoundedDomain::shutdown);
    }

    public Map<String, BoundedDomainRest> boundedDomainRests() {
        return Collections.unmodifiableMap(this.boundedDomainRests);
    }

    public void registerBoundedDomain(BoundedDomain<?, ?, ?> domain) {
        this.boundedDomains.put(domain.name(), domain);
    }

    public AppsBoundedDomain apps() {
        return (AppsBoundedDomain)this.boundedDomains.get("applications");
    }

    public void registerBoundedDomainRest(BoundedDomainRest domain) {
        this.boundedDomainRests.put(domain.name(), domain);
    }

    public Optional<BoundedDomainRest> getBoundedDomainRest(String name) {
        return Optional.ofNullable(this.boundedDomainRests.get(name));
    }

    public boolean inMemory() {
        return Boolean.parseBoolean(this.properties.getProperty(IN_MEMORY_PROPERTY, "true"));
    }

    public String imports(String domain) {
        return "%s/%s".formatted(this.getProperty(IMPORTS_DIRECTORY_PROPERTY), domain);
    }

    public String resources(String domain) {
        return "%s/%s".formatted(this.imports(domain), "resources");
    }

    public String databases() {
        return this.getProperty(DATABASES_DIRECTORY_PROPERTY);
    }

    private void ofAppDomain() {
        AppsEntities realm = this.inMemory() ? new AppsEntities() : new AppsEntities(Path.of(this.databases(), "applications"));
        AppsBoundedDomain domain = new AppsBoundedDomain(this, realm, new AppsBusinessLogic(realm), new AppsAdapter(realm, Path.of(this.imports("applications"), new String[0])), this);
        this.registerBoundedDomain(domain);
    }
}

