/*
 * Decompiled with CFR 0.152.
 */
package net.tangly.app;

import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.applayout.AppLayout;
import com.vaadin.flow.component.applayout.DrawerToggle;
import com.vaadin.flow.component.contextmenu.MenuItem;
import com.vaadin.flow.component.contextmenu.SubMenu;
import com.vaadin.flow.component.html.Image;
import com.vaadin.flow.component.menubar.MenuBar;
import com.vaadin.flow.component.tabs.Tab;
import com.vaadin.flow.component.tabs.Tabs;
import com.vaadin.flow.server.AbstractStreamResource;
import com.vaadin.flow.server.InputStreamFactory;
import com.vaadin.flow.server.StreamResource;
import com.vaadin.flow.server.VaadinSession;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.IntStream;
import net.tangly.app.Tenant;
import net.tangly.app.ui.AppsBoundedDomainUi;
import net.tangly.app.ui.CmdChangePassword;
import net.tangly.app.ui.CmdLogin;
import net.tangly.app.ui.CmdLogout;
import net.tangly.core.domain.User;
import net.tangly.ui.app.domain.BoundedDomainUi;
import net.tangly.ui.components.VaadinUtils;
import org.jetbrains.annotations.NotNull;

public class ApplicationView
extends AppLayout {
    public static final String USERNAME = "username";
    public static final String USER = "user";
    public static final String IMAGE_NAME = "icon.png";
    private final Map<String, BoundedDomainUi<?>> boundedDomainUis;
    private Tabs tabs;
    private Tenant tenant;
    private final boolean hasAuthentication;
    private final MenuBar menuBar;

    public ApplicationView(Tenant tenant, boolean hasAuthentication) {
        this.tenant = tenant;
        this.hasAuthentication = hasAuthentication;
        this.boundedDomainUis = new TreeMap();
        this.setPrimarySection(AppLayout.Section.NAVBAR);
        this.menuBar = new MenuBar();
        this.menuBar.setOpenOnHover(true);
        if (Objects.nonNull(tenant)) {
            this.ofAppDomainUi();
        }
    }

    public Tenant tenant() {
        return this.tenant;
    }

    public void userChanged(@NotNull Tenant tenant, @NotNull User user) {
        this.tenant = tenant;
        this.boundedDomainUis.clear();
        try (InputStream stream = Files.newInputStream(Path.of(tenant.getProperty("tenant.root.directory"), IMAGE_NAME), new OpenOption[0]);){
            byte[] buffer = stream.readAllBytes();
            Image logo = new Image((AbstractStreamResource)new StreamResource(IMAGE_NAME, (InputStreamFactory & Serializable)() -> new ByteArrayInputStream(buffer)), IMAGE_NAME);
            logo.setHeight("44px");
            this.addToNavbar(new Component[]{new DrawerToggle(), logo, this.menuBar});
        }
        catch (IOException e) {
            this.addToNavbar(new Component[]{new DrawerToggle(), this.menuBar});
        }
        this.ofAppDomainUi();
    }

    public static String username() {
        return VaadinSession.getCurrent() != null ? (String)VaadinSession.getCurrent().getAttribute(USERNAME) : null;
    }

    public static User user() {
        return VaadinSession.getCurrent() != null ? (User)VaadinSession.getCurrent().getAttribute(USER) : null;
    }

    protected void onAttach(@NotNull AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        if (this.hasAuthentication && Objects.isNull(VaadinUtils.getAttribute((Component)this, (String)USER))) {
            new CmdLogin(this).execute();
        }
    }

    protected void onDetach(@NotNull DetachEvent detachEvent) {
        super.onDetach(detachEvent);
        this.boundedDomainUis().values().forEach(BoundedDomainUi::detach);
    }

    public void registerBoundedDomainUi(BoundedDomainUi<?> domain) {
        this.boundedDomainUis.put(domain.name(), domain);
    }

    public Optional<BoundedDomainUi<?>> getBoundedDomainUi(String name) {
        return Optional.ofNullable(this.boundedDomainUis.get(name));
    }

    public Map<String, BoundedDomainUi<?>> boundedDomainUis() {
        return Collections.unmodifiableMap(this.boundedDomainUis);
    }

    protected final void selectBoundedDomainUi(@NotNull String domainName) {
        this.getBoundedDomainUi(domainName).ifPresent(this::selectBoundedDomainUi);
        this.domainTab(domainName).ifPresent(arg_0 -> ((Tabs)this.tabs).setSelectedTab(arg_0));
    }

    protected final void selectBoundedDomainUi(Tabs.SelectedChangeEvent event) {
        this.getBoundedDomainUi(event.getSelectedTab().getLabel()).ifPresent(this::selectBoundedDomainUi);
    }

    protected void selectBoundedDomainUi(@NotNull BoundedDomainUi<?> ui) {
        this.menuBar.removeAll();
        ui.select((AppLayout)this, this.menuBar);
        if (this.hasAuthentication) {
            MenuItem menuItem = this.menuBar.addItem("User");
            SubMenu subMenu = (SubMenu)menuItem.getSubMenu();
            subMenu.addItem("Logout", (ComponentEventListener & Serializable)e -> new CmdLogout((Component)this).execute());
            subMenu.addItem("Change Password", (ComponentEventListener & Serializable)e -> new CmdChangePassword(this.tenant.apps(), ApplicationView.user()).execute());
        }
    }

    protected void drawerMenu(User user) {
        this.tabs = new Tabs(this.boundedDomainUis().keySet().stream().map(o -> new Tab(o)).toList().toArray(new Tab[0]));
        this.tabs.setOrientation(Tabs.Orientation.VERTICAL);
        this.addToDrawer(new Component[]{this.tabs});
        this.tabs.addSelectedChangeListener(this::selectBoundedDomainUi);
        this.boundedDomainUis().values().forEach(o -> {
            boolean hasAccessToDomain = Objects.isNull(user) || user.accessRightsFor(o.name()).isPresent();
            this.domainTab(o.name()).ifPresent(tab -> {
                tab.setEnabled(o.domain().enabled() && hasAccessToDomain);
                if (Objects.nonNull(user)) {
                    o.userChanged(user);
                }
            });
        });
    }

    protected MenuBar menuBar() {
        return this.menuBar;
    }

    protected Optional<Tab> domainTab(String domain) {
        return Objects.isNull(this.tabs) ? Optional.empty() : IntStream.range(0, this.tabs.getComponentCount()).mapToObj(i -> this.tabs.getTabAt(i)).filter(o -> o.getLabel().equals(domain)).findAny();
    }

    private void ofAppDomainUi() {
        this.registerBoundedDomainUi(new AppsBoundedDomainUi(this.tenant.apps()));
        this.domainTab("applications").ifPresent(tab -> tab.setEnabled(this.hasAuthentication));
    }
}

