/*
 * Decompiled with CFR 0.152.
 */
package net.tangly.app;

import java.nio.file.Path;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.tangly.app.Tenant;
import net.tangly.commons.utilities.FileUtilities;
import net.tangly.core.domain.DomainAudit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public final class Application {
    private static final Application self = new Application();
    private static final Logger logger = LogManager.getLogger();
    private final ScheduledExecutorService service;
    private final Map<String, Tenant> tenants = new HashMap<String, Tenant>();

    public static Application instance() {
        return self;
    }

    public Application() {
        this.service = Executors.newSingleThreadScheduledExecutor();
        this.service.scheduleAtFixedRate(this::archiveTenants, 1L, 1L, TimeUnit.HOURS);
    }

    public void putTenant(@NotNull Tenant tenant) {
        this.tenants.put(tenant.id(), tenant);
    }

    public void removeTenant(@NotNull String id) {
        this.tenants.remove(id);
    }

    public Tenant tenant(@NotNull String id) {
        return this.tenants.get(id);
    }

    public Collection<Tenant> tenants() {
        return this.tenants.values();
    }

    public void archiveTenants() {
        this.tenants.values().forEach(tenant -> {
            tenant.boundedDomains().forEach(o -> o.port().exportEntities((DomainAudit)o));
            String filename = "%s-%s.zip".formatted(tenant.id(), LocalDateTime.now().truncatedTo(ChronoUnit.SECONDS).format(DateTimeFormatter.ISO_DATE_TIME));
            Path sourceFolder = Path.of(tenant.getProperty("tenant.root.directory"), new String[0]);
            Path archiveFile = Path.of(tenant.getProperty("tenant.archive.directory"), filename);
            FileUtilities.pack((Path)sourceFolder, (Path)archiveFile);
            logger.atInfo().log("Archived tenant {} folder {} to {}", (Object)tenant.id(), (Object)sourceFolder, (Object)archiveFile);
        });
    }
}

