/*
 * Decompiled with CFR 0.152.
 */
package net.tangly.app.api;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.TextNode;
import io.javalin.Javalin;
import io.javalin.config.JavalinConfig;
import io.javalin.openapi.ApiKeyAuth;
import io.javalin.openapi.BasicAuth;
import io.javalin.openapi.BearerAuth;
import io.javalin.openapi.ClientCredentials;
import io.javalin.openapi.CookieAuth;
import io.javalin.openapi.ImplicitFlow;
import io.javalin.openapi.OAuth2;
import io.javalin.openapi.OAuth2Flow;
import io.javalin.openapi.OpenApiContact;
import io.javalin.openapi.OpenApiLicense;
import io.javalin.openapi.OpenID;
import io.javalin.openapi.Security;
import io.javalin.openapi.SecurityScheme;
import io.javalin.openapi.plugin.OpenApiPlugin;
import io.javalin.openapi.plugin.OpenApiPluginConfiguration;
import io.javalin.openapi.plugin.SecurityComponentConfiguration;
import io.javalin.openapi.plugin.swagger.SwaggerConfiguration;
import io.javalin.openapi.plugin.swagger.SwaggerPlugin;
import io.javalin.plugin.Plugin;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import net.tangly.app.Application;

@WebServlet(name="AppJavalinServlet", urlPatterns={"/rest/*"})
public class AppJavalinServlet
extends HttpServlet {
    private final Javalin javalin = Javalin.createStandalone(AppJavalinServlet::create);

    public AppJavalinServlet() {
        Application.instance().boundedDomainRests().values().forEach(o -> o.registerEndPoints(this.javalin));
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.javalin.javalinServlet().service((ServletRequest)req, (ServletResponse)resp);
    }

    private static void create(JavalinConfig config) {
        String docsPath = "/rest/openapi.json";
        OpenApiPluginConfiguration openApiConfiguration = new OpenApiPluginConfiguration().withDocumentationPath(docsPath).withDefinitionConfiguration((version, definition) -> definition.withOpenApiInfo(openApiInfo -> {
            OpenApiContact openApiContact = new OpenApiContact();
            openApiContact.setName("API Support");
            openApiContact.setUrl("https://www.example.com/support");
            openApiContact.setEmail("support@example.com");
            OpenApiLicense openApiLicense = new OpenApiLicense();
            openApiLicense.setName("Apache 2.0");
            openApiLicense.setIdentifier("Apache-2.0");
            openApiInfo.setDescription("Application REST API");
            openApiInfo.setTermsOfService("https://example.com/tos");
            openApiInfo.setContact(openApiContact);
            openApiInfo.setLicense(openApiLicense);
        }).withServer(openApiServer -> {
            openApiServer.setUrl("http://localhost:{port}/{basePath}/" + version + "/");
            openApiServer.setDescription("Server description goes here");
            openApiServer.addVariable("port", "8080", new String[]{"8080"}, "Port of the server");
            openApiServer.addVariable("basePath", "rest", new String[]{"rest"}, "Base path of the server");
        }).withSecurity(new SecurityComponentConfiguration().withSecurityScheme("BasicAuth", (SecurityScheme)new BasicAuth()).withSecurityScheme("BearerAuth", (SecurityScheme)new BearerAuth()).withSecurityScheme("ApiKeyAuth", (SecurityScheme)new ApiKeyAuth()).withSecurityScheme("CookieAuth", (SecurityScheme)new CookieAuth("JSESSIONID")).withSecurityScheme("OpenID", (SecurityScheme)new OpenID("https://example.com/.well-known/openid-configuration")).withSecurityScheme("OAuth2", (SecurityScheme)new OAuth2("This API uses OAuth 2 with the implicit grant flow.").withFlow(((ImplicitFlow)new ImplicitFlow("https://api.example.com/oauth2/authorize").withScope("read_pets", "read your pets")).withScope("write_pets", "modify pets in your account")).withFlow((OAuth2Flow)new ClientCredentials("https://api.example.com/credentials/authorize"))).withGlobalSecurity(new Security("OAuth2").withScope("write_pets").withScope("read_pets"))).withDefinitionProcessor(content -> {
            content.set("test", (JsonNode)new TextNode("Value"));
            return content.toPrettyString();
        }));
        config.plugins.register((Plugin)new OpenApiPlugin(openApiConfiguration));
        SwaggerConfiguration swaggerConfiguration = new SwaggerConfiguration();
        swaggerConfiguration.setUiPath("/rest/swagger");
        swaggerConfiguration.setDocumentationPath(docsPath);
        config.plugins.register((Plugin)new SwaggerPlugin(swaggerConfiguration));
    }

    public record RestConfiguration(String openApiName, String openApiUrl, String openApiEmail, String openApiLicense, String openApiLicenseIdentifier, String openApiServerUrl, String openApiServerDescription, String openApiTermsOfService, String openApiServerVersion) {
    }
}

