/*
 * Decompiled with CFR 0.152.
 */
package net.tangly.app;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.applayout.AppLayout;
import com.vaadin.flow.component.applayout.DrawerToggle;
import com.vaadin.flow.component.html.Image;
import com.vaadin.flow.component.menubar.MenuBar;
import com.vaadin.flow.component.tabs.Tab;
import com.vaadin.flow.component.tabs.Tabs;
import com.vaadin.flow.server.AbstractStreamResource;
import com.vaadin.flow.server.InputStreamFactory;
import com.vaadin.flow.server.StreamResource;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.IntStream;
import net.tangly.ui.app.domain.BoundedDomainUi;

public class ApplicationView
extends AppLayout {
    private final String imageName;
    private final Map<String, BoundedDomainUi<?>> boundedDomainUis;
    private Tabs tabs;
    private final MenuBar menuBar;

    public ApplicationView(String imageName) {
        this.imageName = imageName;
        this.boundedDomainUis = new TreeMap();
        this.setPrimarySection(AppLayout.Section.NAVBAR);
        this.menuBar = new MenuBar();
        this.menuBar.setOpenOnHover(true);
        try {
            byte[] buffer = Thread.currentThread().getContextClassLoader().getResourceAsStream(imageName).readAllBytes();
            Image logo = new Image((AbstractStreamResource)new StreamResource(imageName, (InputStreamFactory & Serializable)() -> new ByteArrayInputStream(buffer)), imageName);
            logo.setHeight("44px");
            this.addToNavbar(new Component[]{new DrawerToggle(), logo, this.menuBar, this.menuBar()});
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void registerBoundedDomainUi(BoundedDomainUi<?> domain) {
        this.boundedDomainUis.put(domain.name(), domain);
    }

    public Optional<BoundedDomainUi<?>> getBoundedDomainUi(String name) {
        return Optional.ofNullable(this.boundedDomainUis.get(name));
    }

    public Map<String, BoundedDomainUi<?>> boundedDomainUis() {
        return Collections.unmodifiableMap(this.boundedDomainUis);
    }

    protected final void selectBoundedDomainUi(String domainName) {
        this.getBoundedDomainUi(domainName).ifPresent(this::selectBoundedDomainUi);
        IntStream.range(0, this.tabs.getComponentCount()).mapToObj(i -> this.tabs.getTabAt(i)).filter(o -> o.getLabel().equals(domainName)).findFirst().ifPresent(arg_0 -> ((Tabs)this.tabs).setSelectedTab(arg_0));
    }

    protected final void selectBoundedDomainUi(Tabs.SelectedChangeEvent event) {
        this.getBoundedDomainUi(event.getSelectedTab().getLabel()).ifPresent(this::selectBoundedDomainUi);
    }

    protected void selectBoundedDomainUi(BoundedDomainUi<?> ui) {
        this.menuBar.removeAll();
        ui.select((AppLayout)this, this.menuBar);
    }

    private MenuBar menuBar() {
        MenuBar menuBar = new MenuBar();
        menuBar.setOpenOnHover(true);
        return menuBar;
    }

    protected void drawerMenu() {
        this.tabs = new Tabs(this.boundedDomainUis().keySet().stream().map(o -> new Tab(o)).toList().toArray(new Tab[0]));
        this.tabs.setOrientation(Tabs.Orientation.VERTICAL);
        this.addToDrawer(new Component[]{this.tabs});
        this.tabs.addSelectedChangeListener(this::selectBoundedDomainUi);
    }
}

