/*
 * Decompiled with CFR 0.152.
 */
package net.tangly.app;

import io.javalin.Javalin;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import net.tangly.app.api.BoundedDomainRest;
import net.tangly.core.TypeRegistry;
import net.tangly.core.domain.BoundedDomain;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.jetty.io.RuntimeIOException;
import org.jetbrains.annotations.NotNull;

public final class Application {
    public static final String IN_MEMORY_PROPERTY = "application.in-memory";
    public static final String DATABASES_DIRECTORY_PROPERTY = "application.root.db.directory";
    public static final String IMPORTS_DIRECTORY_PROPERTY = "application.root.imports.directory";
    public static final String REPORTS_DIRECTORY_PROPERTY = "application.root.reports.directory";
    private static Application self = new Application();
    private static final Logger logger = LogManager.getLogger();
    private final Properties properties = new Properties();
    private final TypeRegistry registry = new TypeRegistry();
    private final Map<String, BoundedDomain<?, ?, ?>> boundedDomains = new HashMap();
    private final Map<String, BoundedDomainRest> boundedDomainRests = new HashMap<String, BoundedDomainRest>();

    public static Application instance() {
        return self;
    }

    public Application() {
        try (InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream("META-INF/application.properties");){
            if (in != null) {
                this.properties.load(in);
            }
        }
        catch (IOException e) {
            logger.atError().log("Application configuration properties load error {}", (Object)e);
            throw new RuntimeIOException((Throwable)e);
        }
    }

    public Properties properties() {
        return this.properties;
    }

    public TypeRegistry registry() {
        return this.registry;
    }

    public void initializeBoundedDomainRests(@NotNull Javalin javalin) {
        this.boundedDomainRests.values().forEach(o -> o.registerEndPoints(javalin));
    }

    public Map<String, BoundedDomain<?, ?, ?>> boundedDomains() {
        return Collections.unmodifiableMap(this.boundedDomains);
    }

    public Map<String, BoundedDomainRest> boundedDomainRests() {
        return Collections.unmodifiableMap(this.boundedDomainRests);
    }

    public void registerBoundedDomain(BoundedDomain<?, ?, ?> domain) {
        this.boundedDomains.put(domain.name(), domain);
    }

    public Optional<BoundedDomain<?, ?, ?>> getBoundedDomain(String name) {
        return Optional.ofNullable(this.boundedDomains.get(name));
    }

    public void registerBoundedDomainRest(BoundedDomainRest domain) {
        this.boundedDomainRests.put(domain.name(), domain);
    }

    public Optional<BoundedDomainRest> getBoundedDomainRest(String name) {
        return Optional.ofNullable(this.boundedDomainRests.get(name));
    }

    public boolean isEnabled(@NotNull String domain) {
        return Boolean.parseBoolean(this.properties().getProperty(domain + ".enabled", "true"));
    }

    public boolean inMemory() {
        return Boolean.parseBoolean(this.properties().getProperty(IN_MEMORY_PROPERTY, "true"));
    }

    public String getProperty(String property) {
        return this.properties().getProperty(property);
    }

    public String imports(String domain) {
        return this.getProperty(IMPORTS_DIRECTORY_PROPERTY) + "/" + domain;
    }

    public String databases() {
        return this.getProperty(DATABASES_DIRECTORY_PROPERTY);
    }

    public String reports(String domain) {
        return this.getProperty(REPORTS_DIRECTORY_PROPERTY) + "/" + domain;
    }
}

