/*
 * Decompiled with CFR 0.152.
 */
package net.takela.auth.access.filter;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import net.takela.auth.access.conf.AccessKeySignProperties;
import net.takela.auth.access.model.AkSk;
import net.takela.auth.access.service.AkSkService;
import net.takela.common.spring.exception.AuthException;
import net.takela.common.spring.filter.HttpRequestCachedServlet;
import org.apache.commons.codec.digest.HmacUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.AntPathMatcher;

public class AccessKeySignFilter
implements Filter {
    private final AccessKeySignProperties signProperties;
    private final AkSkService akSkService;
    private final AntPathMatcher antPathMatcher = new AntPathMatcher();

    public AccessKeySignFilter(AccessKeySignProperties signProperties, AkSkService akSkService) {
        this.signProperties = signProperties;
        this.akSkService = akSkService;
    }

    private boolean isTimestampValid(long timestamp) {
        long timeDiff = Math.abs(System.currentTimeMillis() - timestamp);
        return timeDiff <= this.signProperties.getExpireTime();
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        String serverSign;
        boolean f;
        boolean isAnonymous;
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        if (!this.signProperties.getEnabled().booleanValue()) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        HttpRequestCachedServlet cachedServletRequest = new HttpRequestCachedServlet((HttpServletRequest)servletRequest);
        if (!this.signProperties.getAnonymousUrls().isEmpty() && (isAnonymous = this.signProperties.getAnonymousUrls().stream().anyMatch(url -> this.antPathMatcher.match(url, httpServletRequest.getRequestURI())))) {
            filterChain.doFilter((ServletRequest)cachedServletRequest, servletResponse);
            return;
        }
        if (!this.signProperties.getCheckUrls().isEmpty() && !(f = this.signProperties.getCheckUrls().stream().anyMatch(url -> this.antPathMatcher.match(url, httpServletRequest.getRequestURI())))) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        String ak = httpServletRequest.getHeader(this.signProperties.getAccessKeyHeaderName());
        String timestamp = httpServletRequest.getHeader(this.signProperties.getTimestampHeaderName());
        String sign = httpServletRequest.getHeader(this.signProperties.getSignHeaderName());
        if (StringUtils.isEmpty((CharSequence)ak) || StringUtils.isEmpty((CharSequence)timestamp) || StringUtils.isEmpty((CharSequence)sign)) {
            throw new AuthException("Miss some header", new Object[0]);
        }
        if (!this.isTimestampValid(Long.parseLong(timestamp))) {
            throw new AuthException("Time error", new Object[0]);
        }
        AkSk akSk = this.akSkService.getByAk(ak);
        if (akSk == null) {
            throw new AuthException("Invalid access key", new Object[0]);
        }
        try {
            String dataToSign = this.buildSign(httpServletRequest, ak, timestamp);
            serverSign = HmacUtils.hmacSha256Hex((String)akSk.getSk(), (String)dataToSign);
        }
        catch (Exception e) {
            throw new AuthException("Invalid request", new Object[0]);
        }
        if (!serverSign.equalsIgnoreCase(sign)) {
            throw new AuthException("Invalid request", new Object[0]);
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    private String buildSign(HttpServletRequest request, String ak, String timestamp) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append(timestamp).append(ak).append(request.getMethod()).append(request.getRequestURI());
        String queryString = request.getQueryString();
        sb.append(queryString);
        if (request.getContentType() != null && request.getContentType().toLowerCase().contains("application/json")) {
            String body = this.getBody((InputStream)request.getInputStream());
            sb.append(body);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getBody(InputStream inputStream) {
        StringBuilder sb = new StringBuilder();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
            char[] buffer = new char[1024];
            int bytesRead = -1;
            while ((bytesRead = reader.read(buffer)) > 0) {
                sb.append(buffer, 0, bytesRead);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return sb.toString();
    }
}

