package net.takela.auth.access;

import net.takela.auth.access.conf.AccessKeySignProperties;
import net.takela.auth.access.dao.AkSkDao;
import net.takela.auth.access.filter.AccessKeySignFilter;
import net.takela.auth.access.service.AkSkService;
import org.mybatis.spring.boot.autoconfigure.MybatisAutoConfiguration;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Lazy;

//@AutoConfigureAfter({MybatisAutoConfiguration.class})

/**
 *
 */
public class AccessKeySignAutoConfig {

    /**
     *
     * @return
     */
    @Bean("accessKeySignProperties")
    @ConfigurationProperties(prefix = "auth.access")
    public AccessKeySignProperties accessKeySignProperties(){
        return new AccessKeySignProperties();
    }

    /**
     *
     * @param akSkDao
     * @return
     */
    @Bean
    public AkSkService akSkService(AkSkDao akSkDao){
        return new AkSkService(akSkDao);
    }

    /**
     *
     * @param accessKeySignProperties
     * @param akSkService
     * @return
     */
    @Bean
    public AccessKeySignFilter AccessKeySignFilter(
            @Qualifier("accessKeySignProperties") AccessKeySignProperties accessKeySignProperties,
            AkSkService akSkService){
        return new AccessKeySignFilter( accessKeySignProperties, akSkService);
    }
}
