package materialui.reacteventlistener

import kotlinext.js.jsObject
import react.*

abstract class REventListenerBuilder<Props: PropsWithChildren> internal constructor(
    val type: ComponentType<Props>,
    protected val props: Props = jsObject { }
) : RBuilderImpl() {
    fun attrs(handler: Props.() -> Unit) {
        props.handler()
    }

    fun create() = createElement(type, props, *childList.toTypedArray())
}