/*
 * Decompiled with CFR 0.152.
 */
package net.stoerr.ai.aigenpipeline.framework.task;

import java.io.File;
import javax.annotation.Nonnull;
import net.stoerr.ai.aigenpipeline.framework.task.AIInOut;
import net.stoerr.ai.aigenpipeline.framework.task.AIVersionMarker;

public interface WritingStrategy {
    public static final WritingStrategy WITHOUTVERSION = new WritingStrategy(){

        @Override
        public void write(@Nonnull AIInOut output, @Nonnull String content, @Nonnull String versionComment) {
            output.write(content);
        }

        @Override
        public AIVersionMarker getRecordedVersionMarker(@Nonnull AIInOut output) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Cannot read version marker from file without version comment.");
        }

        public String toString() {
            return "WritingStrategy.WITHOUTVERSION";
        }
    };
    public static final WritingStrategy WITHVERSION = new WritingStrategy(){

        @Override
        public void write(@Nonnull AIInOut output, @Nonnull String content, @Nonnull String versionComment) {
            output.write(this.embedComment(output, content, versionComment));
        }

        @Override
        public AIVersionMarker getRecordedVersionMarker(@Nonnull AIInOut output) {
            String content;
            try {
                content = output.read();
            }
            catch (RuntimeException e) {
                return null;
            }
            AIVersionMarker aiVersionMarker = AIVersionMarker.find(content);
            if (aiVersionMarker == null) {
                File versionFile = new File(output.getFile() + ".version");
                if (!versionFile.exists()) {
                    return null;
                }
                content = AIInOut.of(versionFile).read();
                aiVersionMarker = AIVersionMarker.find(content);
                if (aiVersionMarker == null) {
                    throw new IllegalStateException("Could not find version marker in " + versionFile);
                }
            }
            return aiVersionMarker;
        }

        protected String embedComment(@Nonnull AIInOut outputFile, String content, String comment) {
            String result;
            String extension;
            switch (extension = outputFile.getFile().getName().substring(outputFile.getFile().getName().lastIndexOf(46) + 1)) {
                case "java": 
                case "txt": {
                    result = "// " + comment + "\n\n" + content;
                    break;
                }
                case "html": 
                case "htm": 
                case "xml": 
                case "jsp": 
                case "md": {
                    result = content + "\n\n<!-- " + comment + " -->\n";
                    break;
                }
                case "css": 
                case "js": 
                case "json": {
                    result = "/* " + comment + " */\n\n" + content;
                    break;
                }
                case "sh": 
                case "yaml": {
                    result = "# " + comment + "\n" + content;
                    break;
                }
                default: {
                    result = "/* " + comment + " */\n\n" + content;
                }
            }
            if (!result.endsWith("\n")) {
                result = result + "\n";
            }
            return result;
        }

        public String toString() {
            return "WritingStrategy.WITHVERSION";
        }
    };
    public static final WritingStrategy WITHVERSIONFILE = new WritingStrategy(){

        @Override
        public void write(@Nonnull AIInOut output, @Nonnull String content, @Nonnull String versionComment) {
            output.write(content);
            File versionFile = new File(output.getFile() + ".version");
            AIInOut.of(versionFile).write(versionComment);
        }

        @Override
        public AIVersionMarker getRecordedVersionMarker(@Nonnull AIInOut output) {
            return WITHVERSION.getRecordedVersionMarker(output);
        }

        public String toString() {
            return "WritingStrategy.WITHVERSIONFILE";
        }
    };

    public void write(@Nonnull AIInOut var1, @Nonnull String var2, @Nonnull String var3);

    public AIVersionMarker getRecordedVersionMarker(@Nonnull AIInOut var1);
}

