/*
 * Decompiled with CFR 0.152.
 */
package net.stoerr.ai.aigenpipeline.framework.task;

import java.util.HashSet;
import java.util.List;
import javax.annotation.Nonnull;
import net.stoerr.ai.aigenpipeline.framework.task.AIInOut;
import net.stoerr.ai.aigenpipeline.framework.task.AIVersionMarker;
import net.stoerr.ai.aigenpipeline.framework.task.WritingStrategy;

public interface RegenerationCheckStrategy {
    public static final RegenerationCheckStrategy ALWAYS = (output, inputs, writingStrategy, inputVersions) -> true;
    public static final RegenerationCheckStrategy IF_NOT_EXISTS = (output, inputs, writingStrategy, additionalMarkers) -> !output.getFile().exists();
    public static final RegenerationCheckStrategy IF_OLDER = (output, inputs, writingStrategy, inputVersions) -> {
        if (!output.getFile().exists()) {
            return true;
        }
        long outputTime = output.getFile().lastModified();
        for (AIInOut input : inputs) {
            if (input.getFile().toString().equals("-") || input.getFile().lastModified() <= outputTime) continue;
            return true;
        }
        return false;
    };
    public static final RegenerationCheckStrategy VERSIONMARKER = new VersionMarkerRegenerationCheckStrategy();

    public boolean needsRegeneration(@Nonnull AIInOut var1, @Nonnull List<AIInOut> var2, @Nonnull WritingStrategy var3, @Nonnull List<String> var4);

    public static class VersionMarkerRegenerationCheckStrategy
    implements RegenerationCheckStrategy {
        @Override
        public boolean needsRegeneration(@Nonnull AIInOut output, @Nonnull List<AIInOut> inputs, @Nonnull WritingStrategy writingStrategy, @Nonnull List<String> inputVersions) {
            AIVersionMarker outputVersionMarker = writingStrategy.getRecordedVersionMarker(output);
            if (outputVersionMarker == null) {
                return true;
            }
            List<String> oldInputVersions = outputVersionMarker.getInputVersions();
            return !new HashSet<String>(inputVersions).equals(new HashSet<String>(oldInputVersions));
        }
    }
}

