/*
 * Decompiled with CFR 0.152.
 */
package net.stoerr.ai.aigenpipeline.framework.task;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.stoerr.ai.aigenpipeline.framework.task.SegmentedFile;

public interface AIInOut {
    public String read() throws IllegalStateException;

    public void write(String var1);

    public File getFile();

    default public boolean sameFile(AIInOut other) {
        return this.getFile().getAbsolutePath().equals(other.getFile().getAbsolutePath());
    }

    default public boolean exists() {
        return null != this.getFile() && this.getFile().exists();
    }

    @Nullable
    public static AIInOut of(@Nullable File file) {
        return file != null ? new AIFileInOut(Objects.requireNonNull(file)) : null;
    }

    @Nullable
    public static AIInOut of(@Nullable Path path) {
        return path != null ? new AIFileInOut(Objects.requireNonNull(path.toFile())) : null;
    }

    @Nonnull
    public static AIInOut of(@Nonnull SegmentedFile segmentedFile, int segmentIndex) {
        return new AIFileSegmentInOut(Objects.requireNonNull(segmentedFile), segmentIndex);
    }

    public static AIInOut of(InputStream in) {
        return new AIStreamInOut(in);
    }

    public static class AIStreamInOut
    implements AIInOut {
        private final InputStream in;

        public AIStreamInOut(InputStream in) {
            this.in = in;
        }

        @Override
        public String read() throws IllegalStateException {
            try {
                return new String(this.in.readAllBytes(), StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                throw new IllegalStateException("Could not read input stream", e);
            }
        }

        @Override
        public void write(String content) {
            throw new UnsupportedOperationException("Writing to an input stream is not supported");
        }

        @Override
        public File getFile() {
            return null;
        }

        public String toString() {
            return "input stream";
        }
    }

    public static class AIFileSegmentInOut
    implements AIInOut {
        protected final SegmentedFile segmentedFile;
        protected final int segmentIndex;

        public AIFileSegmentInOut(SegmentedFile segmentedFile, int segmentIndex) {
            this.segmentedFile = segmentedFile;
            this.segmentIndex = segmentIndex;
        }

        @Override
        public String read() {
            return this.segmentedFile.getSegment(this.segmentIndex);
        }

        @Override
        public void write(String content) {
            try {
                this.segmentedFile.writeSegment(this.segmentIndex, content);
            }
            catch (IOException e) {
                throw new IllegalStateException("Could not write segment " + this.segmentIndex + " of " + this.segmentedFile, e);
            }
        }

        @Override
        public File getFile() {
            return this.segmentedFile.getFile();
        }

        public String toString() {
            return this.segmentedFile.getFile() + " segment " + this.segmentIndex;
        }
    }

    public static class AIFileInOut
    implements AIInOut {
        private final File file;

        public AIFileInOut(File file) {
            this.file = file;
        }

        @Override
        public String read() throws IllegalStateException {
            try {
                return Files.readString(this.file.toPath(), StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                throw new IllegalStateException("Could not read " + this.file, e);
            }
        }

        @Override
        public void write(String content) {
            try {
                Files.write(this.file.toPath(), content.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            }
            catch (IOException e) {
                throw new IllegalStateException("Could not write " + this.file, e);
            }
        }

        @Override
        public File getFile() {
            return this.file;
        }

        public String toString() {
            return this.file.toString();
        }
    }
}

