/*
 * Decompiled with CFR 0.152.
 */
package net.stoerr.ai.aigenpipeline.framework.chat;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.stoerr.ai.aigenpipeline.framework.chat.AIChatBuilder;

public class OpenAIChatBuilderImpl
implements AIChatBuilder {
    public static final String MODEL_OPENAIJSON = "openaijson";
    public static final String ENV_ANTHROPIC_VERSION = "ANTHROPIC_API_VERSION";
    public static final String ENV_OPENAI_API_KEY = "OPENAI_API_KEY";
    public static final String ENV_ANTHROPIC_API_KEY = "ANTHROPIC_API_KEY";
    public static final String ANTHROPIC_DEFAULT_VERSION = "2023-06-01";
    public static final int DEFAULT_MAX_TOKENS = 2048;
    protected static final Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static final String ROLE_SYSTEM = "system";
    public static final String ROLE_USER = "user";
    public static final String ROLE_ASSISTANT = "assistant";
    protected final Pattern CODEBLOCK_PATTERN = Pattern.compile("\\A\\s*```\\w*\\n?(.*?)\\n*```\\s*\\Z", 32);
    protected String model = "gpt-4o";
    protected final List<Message> messages = new ArrayList<Message>();
    protected String apiKey;
    protected String organizationId;
    protected int maxTokens = 2048;
    protected String url = "https://api.openai.com/v1/chat/completions";

    @Override
    public AIChatBuilder url(String url) {
        this.url = url;
        return this;
    }

    @Override
    public AIChatBuilder key(String key) {
        this.apiKey = key;
        return this;
    }

    @Override
    public AIChatBuilder organizationId(String organizationId) {
        this.organizationId = organizationId;
        return this;
    }

    @Override
    public AIChatBuilder maxTokens(int maxTokens) {
        this.maxTokens = maxTokens;
        return this;
    }

    @Override
    public AIChatBuilder model(String model) {
        this.model = model;
        return this;
    }

    @Override
    public AIChatBuilder systemMsg(String text) {
        if (text != null && !text.isEmpty()) {
            this.messages.add(0, new Message(ROLE_SYSTEM, text));
        }
        return this;
    }

    @Override
    public AIChatBuilder userMsg(String text) {
        if (text != null && !text.isEmpty()) {
            this.messages.add(new Message(ROLE_USER, text));
        }
        return this;
    }

    @Override
    public AIChatBuilder assistantMsg(String text) {
        if (text != null && !text.isEmpty()) {
            this.messages.add(new Message(ROLE_ASSISTANT, text));
        }
        return this;
    }

    protected String determineApiKey() {
        String key = this.apiKey;
        if (key == null) {
            if (this.isOpenAI()) {
                key = System.getenv(ENV_OPENAI_API_KEY);
            } else if (this.isClaude()) {
                key = System.getenv(ENV_ANTHROPIC_API_KEY);
            }
        }
        return key;
    }

    protected boolean isClaude() {
        return this.url.contains("//api.anthropic.com/");
    }

    protected boolean isOpenAI() {
        return this.url.contains("//api.openai.com/");
    }

    @Override
    public String execute() {
        if (MODEL_OPENAIJSON.equals(this.model)) {
            return this.toJson().replaceAll(Pattern.quote("FIXME(GenAIPipeline)"), "FIXME ");
        }
        String key = this.determineApiKey();
        HttpClient client = HttpClient.newBuilder().version(HttpClient.Version.HTTP_1_1).connectTimeout(Duration.ofSeconds(20L)).build();
        String json = this.toJson();
        HttpRequest.Builder builder = HttpRequest.newBuilder().uri(URI.create(this.url)).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(json));
        if (this.isOpenAI()) {
            builder.header("Authorization", "Bearer " + key);
        } else if (this.isClaude()) {
            String anthropicVersion = System.getenv(ENV_ANTHROPIC_VERSION);
            anthropicVersion = anthropicVersion != null ? anthropicVersion : ANTHROPIC_DEFAULT_VERSION;
            builder.header("x-api-key", this.determineApiKey()).header("anthropic-version", anthropicVersion);
        }
        if (this.organizationId != null) {
            builder.header("OpenAI-Organization", this.organizationId);
        }
        builder.timeout(Duration.ofSeconds(300L));
        HttpRequest request = builder.build();
        try {
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() != 200) {
                throw new IllegalStateException("Unexpected status code " + response.statusCode() + " : " + response.body());
            }
            return this.extractResponse(response.body());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Interrupted while waiting for chat completion response", e);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to execute chat completion request", e);
        }
    }

    @Override
    public String toJson() {
        ChatCompletionRequest request;
        if (this.isClaude()) {
            StringBuilder systemMessage = new StringBuilder();
            ArrayList<Message> filteredMessages = new ArrayList<Message>();
            for (Message message : this.messages) {
                if (ROLE_ASSISTANT.equals(message.role) || ROLE_USER.equals(message.role)) {
                    filteredMessages.add(message);
                    continue;
                }
                if (ROLE_SYSTEM.equals(message.role)) {
                    if (systemMessage.length() > 0) {
                        systemMessage.append("\n\n");
                    }
                    systemMessage.append(message.content);
                    continue;
                }
                throw new IllegalArgumentException("Unknown role " + message.role);
            }
            request = new ChatCompletionRequest(this.model, filteredMessages, 0.0, this.maxTokens);
            if (systemMessage.length() > 0) {
                request.system = systemMessage.toString();
            }
        } else {
            request = new ChatCompletionRequest(this.model, this.messages, 0.0, this.maxTokens);
        }
        return gson.toJson((Object)request);
    }

    protected String extractResponse(String json) {
        boolean stopped;
        String finish_reason;
        String content;
        ChatCompletionResponse response = (ChatCompletionResponse)gson.fromJson(json, ChatCompletionResponse.class);
        if (response.choices != null && !response.choices.isEmpty()) {
            ChatCompletionResponse.Choice choice = response.choices.get(0);
            content = choice.message.content.trim();
            finish_reason = choice.finish_reason;
            stopped = "stop".equals(finish_reason);
        } else if (response.content != null && !response.content.isEmpty()) {
            finish_reason = response.stop_reason;
            stopped = "end_turn".equals(finish_reason);
            content = response.content.get((int)0).text;
        } else {
            throw new IllegalStateException("Could not find answer in response: " + json);
        }
        if (!stopped) {
            String msg = "Invalid finish reason: " + finish_reason + " in response: " + json;
            if (finish_reason != null && finish_reason.contains("length")) {
                msg = msg + "\n- try increasing maxTokens";
            }
            throw new IllegalStateException(msg);
        }
        Matcher matcher = this.CODEBLOCK_PATTERN.matcher(content);
        if (matcher.matches()) {
            content = matcher.group(1);
        }
        return content;
    }

    protected static class ChatCompletionResponse {
        List<Choice> choices;
        List<ClaudeResponseContent> content;
        String stop_reason;

        protected ChatCompletionResponse() {
        }

        static class ClaudeResponseContent {
            String text;

            ClaudeResponseContent() {
            }
        }

        static class Choice {
            Message message;
            String finish_reason;

            Choice() {
            }
        }
    }

    protected static class ChatCompletionRequest {
        String model;
        List<Message> messages;
        double temperature;
        int max_tokens;
        String system;

        ChatCompletionRequest(String model, List<Message> messages, double temperature, int maxTokens) {
            this.model = model;
            this.messages = messages;
            this.temperature = temperature;
            this.max_tokens = maxTokens;
        }
    }

    protected static class Message {
        String role;
        String content;

        Message(String role, String content) {
            this.role = role;
            this.content = content;
        }
    }
}

