/*
 * Decompiled with CFR 0.152.
 */
package net.stoerr.ai.aigenpipeline.framework.task;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class SegmentedFile {
    protected final File file;
    protected final List<Pattern> separatorPatterns;
    protected List<String> segments;
    public static final Pattern REGEX_AIGENPROMPTSTART = Pattern.compile("AIGenPromptStart\\((?<id>[^\\)]+)\\)");

    public SegmentedFile(@Nonnull File file, String ... separatorRegexes) throws IOException {
        this.file = file;
        this.separatorPatterns = Arrays.stream(separatorRegexes).map(Pattern::compile).collect(Collectors.toList());
        this.readAndParseFile();
    }

    protected void readAndParseFile() throws IOException {
        String content = Files.readString(this.file.toPath(), StandardCharsets.UTF_8);
        int startpos = 0;
        this.segments = new ArrayList<String>();
        for (Pattern separator : this.separatorPatterns) {
            Matcher matcher = separator.matcher(content);
            if (!matcher.find(startpos)) {
                throw new IllegalArgumentException("Separator " + separator + " not found in " + this.file);
            }
            this.segments.add(content.substring(startpos, matcher.start()));
            this.segments.add(content.substring(matcher.start(), matcher.end()));
            startpos = matcher.end();
        }
        this.segments.add(content.substring(startpos));
        this.sanityCheck(content);
    }

    public String getSegment(int i) {
        return this.segments.get(2 * i);
    }

    public void writeSegment(int i, String newSegment) throws IOException {
        this.segments.set(2 * i, newSegment);
        Files.write(this.file.toPath(), this.joinSegments().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    public File getFile() {
        return this.file;
    }

    protected void sanityCheck(String content) {
        if (this.segments.size() != 2 * this.separatorPatterns.size() + 1) {
            throw new IllegalStateException("Bug: parsed " + this.segments.size() + " segments, but expected " + (2 * this.separatorPatterns.size() + 1));
        }
        for (int i = 0; i < this.segments.size(); i += 2) {
            for (Pattern separator : this.separatorPatterns) {
                String segment;
                Matcher matcher = separator.matcher(segment = this.segments.get(i));
                if (!matcher.find() || matcher.start() >= segment.length() - 1) continue;
                throw new IllegalStateException("Likely a usage error: separator " + separator + " matches segment " + i + " in " + this.file);
            }
        }
        if (!content.equals(this.joinSegments()) && !(content + "\n").equals(this.joinSegments())) {
            throw new IllegalStateException("Bug: content does not match segments in " + this.file);
        }
    }

    protected String joinSegments() {
        Object fullcontent = String.join((CharSequence)"", this.segments);
        if (!((String)fullcontent).endsWith("\n")) {
            fullcontent = (String)fullcontent + "\n";
        }
        return fullcontent;
    }

    public String toString() {
        return "SegmentedFile [file=" + this.file + ", separatorPatterns=" + this.separatorPatterns + "]";
    }

    public static String wholeLineRegex(String separator) {
        return ".*" + separator + ".*\n";
    }

    public static String[] infilePrompting(String id) {
        return new String[]{SegmentedFile.wholeLineRegex("AIGenPromptStart\\(" + id + "\\)"), SegmentedFile.wholeLineRegex("AIGenCommand\\(" + id + "\\)"), SegmentedFile.wholeLineRegex("AIGenPromptEnd\\(" + id + "\\)"), SegmentedFile.wholeLineRegex("AIGenEnd\\(" + id + "\\)") + "|\\z"};
    }
}

